/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.util;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.SentinelVersion;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Optional;

public final class VersionUtils {
    public static Optional<SentinelVersion> parseVersion(String verStr) {
        if (StringUtil.isBlank((String)verStr)) {
            return Optional.empty();
        }
        try {
            String versionFull = verStr;
            SentinelVersion version = new SentinelVersion();
            int index = versionFull.indexOf("-");
            if (index == 0) {
                return Optional.empty();
            }
            if (index != versionFull.length() - 1 && index > 0) {
                version.setPostfix(versionFull.substring(index + 1));
            }
            if (index >= 0) {
                versionFull = versionFull.substring(0, index);
            }
            int[] ver = new int[3];
            for (int segment = 0; segment < ver.length; ++segment) {
                index = versionFull.indexOf(46);
                if (index < 0) {
                    if (versionFull.length() <= 0) break;
                    ver[segment] = Integer.valueOf(versionFull);
                    break;
                }
                ver[segment] = Integer.valueOf(versionFull.substring(0, index));
                versionFull = versionFull.substring(index + 1);
            }
            if (ver[0] < 1) {
                return Optional.empty();
            }
            return Optional.of(version.setMajorVersion(ver[0]).setMinorVersion(ver[1]).setFixVersion(ver[2]));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private VersionUtils() {
    }
}

