/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.repository.metric;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.MetricEntity;
import com.alibaba.csp.sentinel.dashboard.repository.metric.MetricsRepository;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class InMemoryMetricsRepository
implements MetricsRepository<MetricEntity> {
    private static final long MAX_METRIC_LIVE_TIME_MS = 300000L;
    private Map<String, Map<String, LinkedHashMap<Long, MetricEntity>>> allMetrics = new ConcurrentHashMap();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void save(MetricEntity entity) {
        if (entity == null || StringUtil.isBlank((String)entity.getApp())) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            this.allMetrics.computeIfAbsent(entity.getApp(), e -> new HashMap(16)).computeIfAbsent(entity.getResource(), e -> new /* Unavailable Anonymous Inner Class!! */).put(entity.getTimestamp().getTime(), entity);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void saveAll(Iterable<MetricEntity> metrics) {
        if (metrics == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            metrics.forEach(arg_0 -> this.save(arg_0));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricEntity> queryByAppAndResourceBetween(String app, String resource, long startTime, long endTime) {
        ArrayList<MetricEntity> results = new ArrayList<MetricEntity>();
        if (StringUtil.isBlank((String)app)) {
            return results;
        }
        Map resourceMap = (Map)this.allMetrics.get(app);
        if (resourceMap == null) {
            return results;
        }
        LinkedHashMap metricsMap = (LinkedHashMap)resourceMap.get(resource);
        if (metricsMap == null) {
            return results;
        }
        this.readWriteLock.readLock().lock();
        try {
            for (Map.Entry entry : metricsMap.entrySet()) {
                if ((Long)entry.getKey() < startTime || (Long)entry.getKey() > endTime) continue;
                results.add((MetricEntity)entry.getValue());
            }
            ArrayList<MetricEntity> arrayList = results;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listResourcesOfApp(String app) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtil.isBlank((String)app)) {
            return results;
        }
        Map resourceMap = (Map)this.allMetrics.get(app);
        if (resourceMap == null) {
            return results;
        }
        long minTimeMs = System.currentTimeMillis() - 60000L;
        ConcurrentHashMap resourceCount = new ConcurrentHashMap(32);
        this.readWriteLock.readLock().lock();
        try {
            for (Map.Entry resourceMetrics : resourceMap.entrySet()) {
                for (Map.Entry metrics : ((LinkedHashMap)resourceMetrics.getValue()).entrySet()) {
                    if ((Long)metrics.getKey() < minTimeMs) continue;
                    MetricEntity newEntity = (MetricEntity)metrics.getValue();
                    if (resourceCount.containsKey(resourceMetrics.getKey())) {
                        MetricEntity oldEntity = (MetricEntity)resourceCount.get(resourceMetrics.getKey());
                        oldEntity.addPassQps(newEntity.getPassQps());
                        oldEntity.addRtAndSuccessQps(newEntity.getRt(), newEntity.getSuccessQps());
                        oldEntity.addBlockQps(newEntity.getBlockQps());
                        oldEntity.addExceptionQps(newEntity.getExceptionQps());
                        oldEntity.addCount(1);
                        continue;
                    }
                    resourceCount.put(resourceMetrics.getKey(), MetricEntity.copyOf((MetricEntity)newEntity));
                }
            }
            List list = resourceCount.entrySet().stream().sorted((o1, o2) -> {
                MetricEntity e1 = (MetricEntity)o1.getValue();
                MetricEntity e2 = (MetricEntity)o2.getValue();
                int t = e2.getBlockQps().compareTo(e1.getBlockQps());
                if (t != 0) {
                    return t;
                }
                return e2.getPassQps().compareTo(e1.getPassQps());
            }).map(Map.Entry::getKey).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

