/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.discovery;

import com.alibaba.csp.sentinel.dashboard.discovery.AppInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineDiscovery;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class SimpleMachineDiscovery
implements MachineDiscovery {
    private final ConcurrentMap<String, AppInfo> apps = new ConcurrentHashMap();

    public long addMachine(MachineInfo machineInfo) {
        AssertUtil.notNull((Object)machineInfo, (String)"machineInfo cannot be null");
        AppInfo appInfo = this.apps.computeIfAbsent(machineInfo.getApp(), o -> new AppInfo(machineInfo.getApp(), machineInfo.getAppType()));
        appInfo.addMachine(machineInfo);
        return 1L;
    }

    public boolean removeMachine(String app, String ip, int port) {
        AssertUtil.assertNotBlank((String)app, (String)"app name cannot be blank");
        AppInfo appInfo = (AppInfo)this.apps.get(app);
        if (appInfo != null) {
            return appInfo.removeMachine(ip, port);
        }
        return false;
    }

    public List<String> getAppNames() {
        return new ArrayList<String>(this.apps.keySet());
    }

    public AppInfo getDetailApp(String app) {
        AssertUtil.assertNotBlank((String)app, (String)"app name cannot be blank");
        return (AppInfo)this.apps.get(app);
    }

    public Set<AppInfo> getBriefApps() {
        return new HashSet<AppInfo>(this.apps.values());
    }

    public void removeApp(String app) {
        AssertUtil.assertNotBlank((String)app, (String)"app name cannot be blank");
        this.apps.remove(app);
    }
}

