/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.discovery;

import com.alibaba.csp.sentinel.dashboard.discovery.AppInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineDiscovery;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.SimpleMachineDiscovery;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AppManagement
implements MachineDiscovery {
    @Autowired
    private ApplicationContext context;
    private MachineDiscovery machineDiscovery;

    @PostConstruct
    public void init() {
        this.machineDiscovery = (MachineDiscovery)this.context.getBean(SimpleMachineDiscovery.class);
    }

    public Set<AppInfo> getBriefApps() {
        return this.machineDiscovery.getBriefApps();
    }

    public long addMachine(MachineInfo machineInfo) {
        return this.machineDiscovery.addMachine(machineInfo);
    }

    public boolean removeMachine(String app, String ip, int port) {
        return this.machineDiscovery.removeMachine(app, ip, port);
    }

    public List<String> getAppNames() {
        return this.machineDiscovery.getAppNames();
    }

    public AppInfo getDetailApp(String app) {
        return this.machineDiscovery.getDetailApp(app);
    }

    public void removeApp(String app) {
        this.machineDiscovery.removeApp(app);
    }

    public boolean isValidMachineOfApp(String app, String ip) {
        if (StringUtil.isEmpty((String)app)) {
            return false;
        }
        return Optional.ofNullable(this.getDetailApp(app)).flatMap(a -> a.getMachine(ip)).isPresent();
    }
}

