/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.MetricEntity;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.vo.MetricVo;
import com.alibaba.csp.sentinel.dashboard.repository.metric.MetricsRepository;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/metric"}, produces={"application/json"})
public class MetricController {
    private static Logger logger = LoggerFactory.getLogger(MetricController.class);
    private static final long maxQueryIntervalMs = 3600000L;
    @Autowired
    private MetricsRepository<MetricEntity> metricStore;

    @ResponseBody
    @RequestMapping(value={"/queryTopResourceMetric.json"})
    public Result<?> queryTopResourceMetric(String app, Integer pageIndex, Integer pageSize, Boolean desc, Long startTime, Long endTime, String searchKey) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (pageIndex == null || pageIndex <= 0) {
            pageIndex = 1;
        }
        if (pageSize == null) {
            pageSize = 6;
        }
        if (pageSize >= 20) {
            pageSize = 20;
        }
        if (desc == null) {
            desc = true;
        }
        if (endTime == null) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == null) {
            startTime = endTime - 300000L;
        }
        if (endTime - startTime > 3600000L) {
            return Result.ofFail((int)-1, (String)"time intervalMs is too big, must <= 1h");
        }
        ArrayList<String> resources = this.metricStore.listResourcesOfApp(app);
        logger.debug("queryTopResourceMetric(), resources.size()={}", (Object)resources.size());
        if (resources == null || resources.isEmpty()) {
            return Result.ofSuccess(null);
        }
        if (!desc.booleanValue()) {
            Collections.reverse(resources);
        }
        if (StringUtil.isNotEmpty((String)searchKey)) {
            ArrayList<String> searched = new ArrayList<String>();
            for (String resource : resources) {
                if (!resource.contains(searchKey)) continue;
                searched.add(resource);
            }
            resources = searched;
        }
        int totalPage = (resources.size() + pageSize - 1) / pageSize;
        List topResource = new ArrayList();
        if (pageIndex <= totalPage) {
            topResource = resources.subList((pageIndex - 1) * pageSize, Math.min(pageIndex * pageSize, resources.size()));
        }
        ConcurrentHashMap<String, Iterable> map = new ConcurrentHashMap<String, Iterable>();
        logger.debug("topResource={}", topResource);
        long time = System.currentTimeMillis();
        Iterator iterator = topResource.iterator();
        while (iterator.hasNext()) {
            String resource;
            List entities = this.metricStore.queryByAppAndResourceBetween(app, resource = (String)iterator.next(), startTime.longValue(), endTime.longValue());
            logger.debug("resource={}, entities.size()={}", (Object)resource, entities == null ? "null" : Integer.valueOf(entities.size()));
            List vos = MetricVo.fromMetricEntities((Collection)entities, (String)resource);
            Iterable vosSorted = this.sortMetricVoAndDistinct(vos);
            map.put(resource, vosSorted);
        }
        logger.debug("queryTopResourceMetric() total query time={} ms", (Object)(System.currentTimeMillis() - time));
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(16);
        resultMap.put("totalCount", Integer.valueOf(resources.size()));
        resultMap.put("totalPage", Integer.valueOf(totalPage));
        resultMap.put("pageIndex", pageIndex);
        resultMap.put("pageSize", pageSize);
        LinkedHashMap map2 = new LinkedHashMap();
        for (String identity : topResource) {
            map2.put(identity, map.get(identity));
        }
        resultMap.put("metric", map2);
        return Result.ofSuccess(resultMap);
    }

    @ResponseBody
    @RequestMapping(value={"/queryByAppAndResource.json"})
    public Result<?> queryByAppAndResource(String app, String identity, Long startTime, Long endTime) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)identity)) {
            return Result.ofFail((int)-1, (String)"identity can't be null or empty");
        }
        if (endTime == null) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == null) {
            startTime = endTime - 60000L;
        }
        if (endTime - startTime > 3600000L) {
            return Result.ofFail((int)-1, (String)"time intervalMs is too big, must <= 1h");
        }
        List entities = this.metricStore.queryByAppAndResourceBetween(app, identity, startTime.longValue(), endTime.longValue());
        List vos = MetricVo.fromMetricEntities((Collection)entities, (String)identity);
        return Result.ofSuccess((Object)this.sortMetricVoAndDistinct(vos));
    }

    private Iterable<MetricVo> sortMetricVoAndDistinct(List<MetricVo> vos) {
        if (vos == null) {
            return null;
        }
        TreeMap<Long, MetricVo> map = new TreeMap<Long, MetricVo>();
        for (MetricVo vo : vos) {
            MetricVo oldVo = (MetricVo)map.get(vo.getTimestamp());
            if (oldVo != null && vo.getGmtCreate() <= oldVo.getGmtCreate()) continue;
            map.put(vo.getTimestamp(), vo);
        }
        return map.values();
    }
}

