/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.DegradeRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStrategy;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/degrade"})
public class DegradeController {
    private final Logger logger = LoggerFactory.getLogger(DegradeController.class);
    @Autowired
    private RuleRepository<DegradeRuleEntity, Long> repository;
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private AppManagement appManagement;

    @GetMapping(value={"/rules.json"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<DegradeRuleEntity>> apiQueryMachineRules(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (!this.appManagement.isValidMachineOfApp(app, ip)) {
            return Result.ofFail((int)-1, (String)"given ip does not belong to given app");
        }
        try {
            List rules = this.sentinelApiClient.fetchDegradeRuleOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            this.logger.error("queryApps error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    @PostMapping(value={"/rule"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<DegradeRuleEntity> apiAddRule(@RequestBody DegradeRuleEntity entity) {
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (DegradeRuleEntity)this.repository.save((Object)entity);
        }
        catch (Throwable t) {
            this.logger.error("Failed to add new degrade rule, app={}, ip={}", new Object[]{entity.getApp(), entity.getIp(), t});
            return Result.ofThrowable((int)-1, (Throwable)t);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)entity.getApp());
        }
        return Result.ofSuccess((Object)entity);
    }

    @PutMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<DegradeRuleEntity> apiUpdateRule(@PathVariable(value="id") Long id, @RequestBody DegradeRuleEntity entity) {
        if (id == null || id <= 0L) {
            return Result.ofFail((int)-1, (String)"id can't be null or negative");
        }
        DegradeRuleEntity oldEntity = (DegradeRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofFail((int)-1, (String)("Degrade rule does not exist, id=" + id));
        }
        entity.setApp(oldEntity.getApp());
        entity.setIp(oldEntity.getIp());
        entity.setPort(oldEntity.getPort());
        entity.setId(oldEntity.getId());
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setGmtCreate(oldEntity.getGmtCreate());
        entity.setGmtModified(new Date());
        try {
            entity = (DegradeRuleEntity)this.repository.save((Object)entity);
        }
        catch (Throwable t) {
            this.logger.error("Failed to save degrade rule, id={}, rule={}", new Object[]{id, entity, t});
            return Result.ofThrowable((int)-1, (Throwable)t);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)entity.getApp());
        }
        return Result.ofSuccess((Object)entity);
    }

    @DeleteMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> delete(@PathVariable(value="id") Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        DegradeRuleEntity oldEntity = (DegradeRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete((Object)id);
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to delete degrade rule, id={}", (Object)id, (Object)throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)oldEntity.getApp());
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.sentinelApiClient.setDegradeRuleOfMachine(app, ip, port.intValue(), rules);
    }

    private <R> Result<R> checkEntityInternal(DegradeRuleEntity entity) {
        if (StringUtil.isBlank((String)entity.getApp())) {
            return Result.ofFail((int)-1, (String)"app can't be blank");
        }
        if (StringUtil.isBlank((String)entity.getIp())) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (!this.appManagement.isValidMachineOfApp(entity.getApp(), entity.getIp())) {
            return Result.ofFail((int)-1, (String)"given ip does not belong to given app");
        }
        if (entity.getPort() == null || entity.getPort() <= 0) {
            return Result.ofFail((int)-1, (String)("invalid port: " + entity.getPort()));
        }
        if (StringUtil.isBlank((String)entity.getLimitApp())) {
            return Result.ofFail((int)-1, (String)"limitApp can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getResource())) {
            return Result.ofFail((int)-1, (String)"resource can't be null or empty");
        }
        Double threshold = entity.getCount();
        if (threshold == null || threshold < 0.0) {
            return Result.ofFail((int)-1, (String)("invalid threshold: " + threshold));
        }
        Integer recoveryTimeoutSec = entity.getTimeWindow();
        if (recoveryTimeoutSec == null || recoveryTimeoutSec <= 0) {
            return Result.ofFail((int)-1, (String)"recoveryTimeout should be positive");
        }
        Integer strategy = entity.getGrade();
        if (strategy == null) {
            return Result.ofFail((int)-1, (String)"circuit breaker strategy cannot be null");
        }
        if (strategy < CircuitBreakerStrategy.SLOW_REQUEST_RATIO.getType() || strategy > 2) {
            return Result.ofFail((int)-1, (String)("Invalid circuit breaker strategy: " + strategy));
        }
        if (entity.getMinRequestAmount() == null || entity.getMinRequestAmount() <= 0) {
            return Result.ofFail((int)-1, (String)"Invalid minRequestAmount");
        }
        if (entity.getStatIntervalMs() == null || entity.getStatIntervalMs() <= 0) {
            return Result.ofFail((int)-1, (String)"Invalid statInterval");
        }
        if (strategy == 0) {
            Double slowRatio = entity.getSlowRatioThreshold();
            if (slowRatio == null) {
                return Result.ofFail((int)-1, (String)"SlowRatioThreshold is required for slow request ratio strategy");
            }
            if (slowRatio < 0.0 || slowRatio > 1.0) {
                return Result.ofFail((int)-1, (String)"SlowRatioThreshold should be in range: [0.0, 1.0]");
            }
        } else if (strategy == 1 && threshold > 1.0) {
            return Result.ofFail((int)-1, (String)"Ratio threshold should be in range: [0.0, 1.0]");
        }
        return null;
    }
}

