/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.AuthorityRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authority"})
public class AuthorityRuleController {
    private final Logger logger = LoggerFactory.getLogger(AuthorityRuleController.class);
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private RuleRepository<AuthorityRuleEntity, Long> repository;
    @Autowired
    private AppManagement appManagement;

    @GetMapping(value={"/rules"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<AuthorityRuleEntity>> apiQueryAllRulesForMachine(@RequestParam String app, @RequestParam String ip, @RequestParam Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app cannot be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip cannot be null or empty");
        }
        if (port == null || port <= 0) {
            return Result.ofFail((int)-1, (String)"Invalid parameter: port");
        }
        if (!this.appManagement.isValidMachineOfApp(app, ip)) {
            return Result.ofFail((int)-1, (String)"given ip does not belong to given app");
        }
        try {
            List rules = this.sentinelApiClient.fetchAuthorityRulesOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when querying authority rules", throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    private <R> Result<R> checkEntityInternal(AuthorityRuleEntity entity) {
        if (entity == null) {
            return Result.ofFail((int)-1, (String)"bad rule body");
        }
        if (StringUtil.isBlank((String)entity.getApp())) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getIp())) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (entity.getPort() == null || entity.getPort() <= 0) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (entity.getRule() == null) {
            return Result.ofFail((int)-1, (String)"rule can't be null");
        }
        if (StringUtil.isBlank((String)entity.getResource())) {
            return Result.ofFail((int)-1, (String)"resource name cannot be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getLimitApp())) {
            return Result.ofFail((int)-1, (String)"limitApp should be valid");
        }
        if (entity.getStrategy() != 0 && entity.getStrategy() != 1) {
            return Result.ofFail((int)-1, (String)"Unknown strategy (must be blacklist or whitelist)");
        }
        return null;
    }

    @PostMapping(value={"/rule"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<AuthorityRuleEntity> apiAddAuthorityRule(@RequestBody AuthorityRuleEntity entity) {
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setId(null);
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (AuthorityRuleEntity)this.repository.save((Object)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to add authority rule", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.info("Publish authority rules failed after rule add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @PutMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<AuthorityRuleEntity> apiUpdateParamFlowRule(@PathVariable(value="id") Long id, @RequestBody AuthorityRuleEntity entity) {
        if (id == null || id <= 0L) {
            return Result.ofFail((int)-1, (String)"Invalid id");
        }
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setId(id);
        Date date = new Date();
        entity.setGmtCreate(null);
        entity.setGmtModified(date);
        try {
            entity = (AuthorityRuleEntity)this.repository.save((Object)entity);
            if (entity == null) {
                return Result.ofFail((int)-1, (String)"Failed to save authority rule");
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to save authority rule", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.info("Publish authority rules failed after rule update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @DeleteMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> apiDeleteRule(@PathVariable(value="id") Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id cannot be null");
        }
        AuthorityRuleEntity oldEntity = (AuthorityRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete((Object)id);
        }
        catch (Exception e) {
            return Result.ofFail((int)-1, (String)e.getMessage());
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.error("Publish authority rules failed after rule delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.sentinelApiClient.setAuthorityRuleOfMachine(app, ip, port.intValue(), rules);
    }
}

