/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.auth.SimpleWebAuthServiceImpl;
import com.alibaba.csp.sentinel.dashboard.config.DashboardConfig;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthController.class);
    @Value(value="${auth.username:sentinel}")
    private String authUsername;
    @Value(value="${auth.password:sentinel}")
    private String authPassword;
    @Autowired
    private AuthService<HttpServletRequest> authService;

    @PostMapping(value={"/login"})
    public Result<AuthService.AuthUser> login(HttpServletRequest request, String username, String password) {
        if (StringUtils.isNotBlank((String)DashboardConfig.getAuthUsername())) {
            this.authUsername = DashboardConfig.getAuthUsername();
        }
        if (StringUtils.isNotBlank((String)DashboardConfig.getAuthPassword())) {
            this.authPassword = DashboardConfig.getAuthPassword();
        }
        if (StringUtils.isNotBlank((String)this.authUsername) && !this.authUsername.equals(username) || StringUtils.isNotBlank((String)this.authPassword) && !this.authPassword.equals(password)) {
            LOGGER.error("Login failed: Invalid username or password, username=" + username);
            return Result.ofFail((int)-1, (String)"Invalid username or password");
        }
        SimpleWebAuthServiceImpl.SimpleWebAuthUserImpl authUser = new SimpleWebAuthServiceImpl.SimpleWebAuthUserImpl(username);
        request.getSession().setAttribute("session_sentinel_admin", (Object)authUser);
        return Result.ofSuccess((Object)authUser);
    }

    @PostMapping(value={"/logout"})
    public Result<?> logout(HttpServletRequest request) {
        request.getSession().invalidate();
        return Result.ofSuccess(null);
    }

    @PostMapping(value={"/check"})
    public Result<?> check(HttpServletRequest request) {
        AuthService.AuthUser authUser = this.authService.getAuthUser((Object)request);
        if (authUser == null) {
            return Result.ofFail((int)-1, (String)"Not logged in");
        }
        return Result.ofSuccess((Object)authUser);
    }
}

