/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.config;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class DashboardConfig {
    public static final int DEFAULT_MACHINE_HEALTHY_TIMEOUT_MS = 60000;
    public static final String CONFIG_AUTH_USERNAME = "sentinel.dashboard.auth.username";
    public static final String CONFIG_AUTH_PASSWORD = "sentinel.dashboard.auth.password";
    public static final String CONFIG_HIDE_APP_NO_MACHINE_MILLIS = "sentinel.dashboard.app.hideAppNoMachineMillis";
    public static final String CONFIG_REMOVE_APP_NO_MACHINE_MILLIS = "sentinel.dashboard.removeAppNoMachineMillis";
    public static final String CONFIG_UNHEALTHY_MACHINE_MILLIS = "sentinel.dashboard.unhealthyMachineMillis";
    public static final String CONFIG_AUTO_REMOVE_MACHINE_MILLIS = "sentinel.dashboard.autoRemoveMachineMillis";
    private static final ConcurrentMap<String, Object> cacheMap = new ConcurrentHashMap();

    @NonNull
    private static String getConfig(String name) {
        String val = System.getenv(name);
        if (StringUtils.isNotEmpty((String)val)) {
            return val;
        }
        val = System.getProperty(name);
        if (StringUtils.isNotEmpty((String)val)) {
            return val;
        }
        return "";
    }

    protected static String getConfigStr(String name) {
        if (cacheMap.containsKey(name)) {
            return (String)cacheMap.get(name);
        }
        String val = DashboardConfig.getConfig((String)name);
        if (StringUtils.isBlank((String)val)) {
            return null;
        }
        cacheMap.put(name, val);
        return val;
    }

    protected static int getConfigInt(String name, int defaultVal, int minVal) {
        if (cacheMap.containsKey(name)) {
            return (Integer)cacheMap.get(name);
        }
        int val = NumberUtils.toInt((String)DashboardConfig.getConfig((String)name));
        if (val == 0) {
            val = defaultVal;
        } else if (val < minVal) {
            val = minVal;
        }
        cacheMap.put(name, val);
        return val;
    }

    public static String getAuthUsername() {
        return DashboardConfig.getConfigStr((String)"sentinel.dashboard.auth.username");
    }

    public static String getAuthPassword() {
        return DashboardConfig.getConfigStr((String)"sentinel.dashboard.auth.password");
    }

    public static int getHideAppNoMachineMillis() {
        return DashboardConfig.getConfigInt((String)"sentinel.dashboard.app.hideAppNoMachineMillis", (int)0, (int)60000);
    }

    public static int getRemoveAppNoMachineMillis() {
        return DashboardConfig.getConfigInt((String)"sentinel.dashboard.removeAppNoMachineMillis", (int)0, (int)120000);
    }

    public static int getAutoRemoveMachineMillis() {
        return DashboardConfig.getConfigInt((String)"sentinel.dashboard.autoRemoveMachineMillis", (int)0, (int)300000);
    }

    public static int getUnhealthyMachineMillis() {
        return DashboardConfig.getConfigInt((String)"sentinel.dashboard.unhealthyMachineMillis", (int)60000, (int)30000);
    }

    public static void clearCache() {
        cacheMap.clear();
    }
}

