/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.metadata.v4.MetadataStaxReader;
import org.apache.maven.metadata.v4.MetadataStaxWriter;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;

@Deprecated
public abstract class AbstractRepositoryMetadata
implements RepositoryMetadata {
    private static final String LS = System.lineSeparator();
    private Metadata metadata;

    protected AbstractRepositoryMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getRemoteFilename() {
        return "maven-metadata.xml";
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return "maven-metadata-" + repository.getKey() + ".xml";
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        try {
            this.updateRepositoryMetadata(localRepository, remoteRepository);
        }
        catch (IOException | XMLStreamException e) {
            throw new RepositoryMetadataStoreException("Error updating group repository metadata", e);
        }
    }

    protected void updateRepositoryMetadata(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws IOException, XMLStreamException {
        boolean changed;
        Metadata metadata = null;
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)this, remoteRepository));
        if (metadataFile.length() == 0L) {
            if (!metadataFile.delete()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                metadataFile.delete();
            }
        } else if (metadataFile.exists()) {
            try (InputStream input = Files.newInputStream(metadataFile.toPath(), new OpenOption[0]);){
                metadata = new Metadata(new MetadataStaxReader().read(input, false));
            }
        }
        if (metadata == null) {
            metadata = this.metadata;
            changed = true;
        } else {
            changed = metadata.merge(this.metadata);
        }
        String version = metadata.getVersion();
        if ("LATEST".equals(version) || "RELEASE".equals(version)) {
            metadata.setVersion(null);
        }
        if (changed || !metadataFile.exists()) {
            metadataFile.getParentFile().mkdirs();
            try (OutputStream output = Files.newOutputStream(metadataFile.toPath(), new OpenOption[0]);){
                MetadataStaxWriter mappingWriter = new MetadataStaxWriter();
                mappingWriter.write(output, metadata.getDelegate());
            }
        } else {
            metadataFile.setLastModified(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "repository metadata for: '" + this.getKey() + "'";
    }

    protected static Metadata createMetadata(Artifact artifact, Versioning versioning) {
        Metadata metadata = new Metadata();
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getVersion());
        metadata.setVersioning(versioning);
        return metadata;
    }

    protected static Versioning createVersioning(Snapshot snapshot) {
        Versioning versioning = new Versioning();
        versioning.setSnapshot(snapshot);
        return versioning;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void merge(ArtifactMetadata metadata) {
        AbstractRepositoryMetadata repoMetadata = (AbstractRepositoryMetadata)metadata;
        this.metadata.merge(repoMetadata.getMetadata());
    }

    public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        AbstractRepositoryMetadata repoMetadata = (AbstractRepositoryMetadata)metadata;
        this.metadata.merge(repoMetadata.getMetadata());
    }

    public String extendedToString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(LS).append("Repository Metadata").append(LS).append("--------------------------");
        buffer.append(LS).append("GroupId: ").append(this.getGroupId());
        buffer.append(LS).append("ArtifactId: ").append(this.getArtifactId());
        buffer.append(LS).append("Metadata Type: ").append(this.getClass().getName());
        return buffer.toString();
    }

    @Override
    public int getNature() {
        return 1;
    }

    @Override
    public ArtifactRepositoryPolicy getPolicy(ArtifactRepository repository) {
        int nature = this.getNature();
        if ((nature & 3) == 3) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(repository.getReleases());
            policy.merge(repository.getSnapshots());
            return policy;
        }
        if ((nature & 2) != 0) {
            return repository.getSnapshots();
        }
        return repository.getReleases();
    }
}

