/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.path;

import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.root.RootLocator;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
@Singleton
@Deprecated
public class ProfileActivationFilePathInterpolator {
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;

    @Inject
    public ProfileActivationFilePathInterpolator(PathTranslator pathTranslator, RootLocator rootLocator) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
    }

    public String interpolate(String path, ProfileActivationContext context) throws InterpolationException {
        if (path == null) {
            return null;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final File basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression) || "project.basedir".equals(expression)) {
                        return basedir.getAbsolutePath();
                    }
                    return null;
                }
            });
        } else if (path.contains("${basedir}")) {
            return null;
        }
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("project.rootDirectory".equals(expression)) {
                    Path base = basedir != null ? basedir.toPath() : null;
                    Path root = ProfileActivationFilePathInterpolator.this.rootLocator.findMandatoryRoot(base);
                    return root.toFile().getAbsolutePath();
                }
                return null;
            }
        });
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getSystemProperties()));
        String absolutePath = interpolator.interpolate(path, "");
        return this.pathTranslator.alignToBaseDirectory(absolutePath, basedir);
    }
}

