/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.internal.impl.resolver.VersionsMetadata;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

class VersionsMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, VersionsMetadata> versions = new LinkedHashMap<Object, VersionsMetadata>();
    private final Map<Object, VersionsMetadata> processedVersions = new LinkedHashMap<Object, VersionsMetadata>();
    private final Instant timestamp;

    VersionsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    VersionsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private VersionsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Instant)ConfigUtils.getObject((RepositorySystemSession)session, (Object)MonotonicClock.now(), (String[])new String[]{"maven.startInstant"});
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof VersionsMetadata)) continue;
            it.remove();
            VersionsMetadata versionsMetadata = (VersionsMetadata)metadata;
            this.processedVersions.put(versionsMetadata.getKey(), versionsMetadata);
        }
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            VersionsMetadata versionsMetadata;
            Object key = VersionsMetadata.getKey(artifact);
            if (this.processedVersions.get(key) != null || (versionsMetadata = this.versions.get(key)) != null) continue;
            versionsMetadata = new VersionsMetadata(artifact, this.timestamp);
            this.versions.put(key, versionsMetadata);
        }
        return this.versions.values();
    }
}

