/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.api.metadata.Metadata;
import org.apache.maven.api.metadata.Snapshot;
import org.apache.maven.api.metadata.SnapshotVersion;
import org.apache.maven.api.metadata.Versioning;
import org.apache.maven.internal.impl.resolver.MavenMetadata;
import org.apache.maven.internal.impl.resolver.MavenSnapshotMetadata;
import org.eclipse.aether.artifact.Artifact;

final class RemoteSnapshotMetadata
extends MavenSnapshotMetadata {
    public static final String DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT = "yyyyMMdd.HHmmss";
    private final Map<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
    private final Integer buildNumber;

    RemoteSnapshotMetadata(Artifact artifact, Instant timestamp, Integer buildNumber) {
        super(RemoteSnapshotMetadata.createRepositoryMetadata(artifact), (Path)null, timestamp);
        this.buildNumber = buildNumber;
    }

    private RemoteSnapshotMetadata(Metadata metadata, Path path, Instant timestamp, Integer buildNumber) {
        super(metadata, path, timestamp);
        this.buildNumber = buildNumber;
    }

    @Deprecated
    public MavenMetadata setFile(File file) {
        return new RemoteSnapshotMetadata(this.metadata, file.toPath(), this.timestamp, this.buildNumber);
    }

    public MavenMetadata setPath(Path path) {
        return new RemoteSnapshotMetadata(this.metadata, path, this.timestamp, this.buildNumber);
    }

    public String getExpandedVersion(Artifact artifact) {
        String key = this.getKey(artifact.getClassifier(), artifact.getExtension());
        return this.versions.get(key).getVersion();
    }

    @Override
    protected void merge(Metadata recessive) {
        String lastUpdated;
        Snapshot snapshot;
        if (this.metadata.getVersioning() == null) {
            DateTimeFormatter utcDateFormatter = DateTimeFormatter.ofPattern(DEFAULT_SNAPSHOT_TIMESTAMP_FORMAT);
            snapshot = Snapshot.newBuilder().buildNumber(this.buildNumber != null ? this.buildNumber : RemoteSnapshotMetadata.getBuildNumber(recessive) + 1).timestamp(utcDateFormatter.format(this.timestamp.atZone(ZoneOffset.UTC))).build();
            lastUpdated = fmt.format(this.timestamp);
            Versioning versioning = Versioning.newBuilder().snapshot(snapshot).lastUpdated(lastUpdated).build();
            this.metadata = this.metadata.withVersioning(versioning);
        } else {
            snapshot = this.metadata.getVersioning().getSnapshot();
            lastUpdated = this.metadata.getVersioning().getLastUpdated();
        }
        for (Artifact artifact : this.artifacts) {
            Object version = artifact.getVersion();
            if (((String)version).endsWith("SNAPSHOT")) {
                String qualifier = snapshot.getTimestamp() + "-" + snapshot.getBuildNumber();
                version = ((String)version).substring(0, ((String)version).length() - "SNAPSHOT".length()) + qualifier;
            }
            SnapshotVersion sv = SnapshotVersion.newBuilder().classifier(artifact.getClassifier()).extension(artifact.getExtension()).version((String)version).updated(lastUpdated).build();
            this.versions.put(this.getKey(sv.getClassifier(), sv.getExtension()), sv);
        }
        this.artifacts.clear();
        Versioning versioning = recessive.getVersioning();
        if (versioning != null) {
            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                String key = this.getKey(sv.getClassifier(), sv.getExtension());
                if (this.versions.containsKey(key)) continue;
                this.versions.put(key, sv);
            }
        }
        this.metadata = this.metadata.withVersioning(this.metadata.getVersioning().withSnapshotVersions(this.versions.values()));
        if (recessive.getPlugins() != null && !recessive.getPlugins().isEmpty()) {
            this.metadata = this.metadata.withPlugins(new ArrayList(recessive.getPlugins()));
        }
    }

    private static int getBuildNumber(Metadata metadata) {
        Snapshot snapshot;
        int number = 0;
        Versioning versioning = metadata.getVersioning();
        if (versioning != null && (snapshot = versioning.getSnapshot()) != null && snapshot.getBuildNumber() > 0) {
            number = snapshot.getBuildNumber();
        }
        return number;
    }
}

