/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;

@Named(value="file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean fileExists;
        boolean missing;
        String path;
        boolean hasMissing;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        if (file == null) {
            return false;
        }
        boolean hasExists = file.getExists() != null && !file.getExists().isEmpty();
        boolean bl = hasMissing = file.getMissing() != null && !file.getMissing().isEmpty();
        if (hasExists) {
            if (hasMissing) {
                problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, String.format("Profile '%s' file activation conflict: Both 'missing' (%s) and 'exists' assertions are defined. The 'missing' assertion will be ignored. Please remove one assertion to resolve this conflict.", profile.getId(), file.getMissing()), file.getLocation((Object)"missing"));
            }
            path = file.getExists();
            missing = false;
        } else if (hasMissing) {
            path = file.getMissing();
            missing = true;
        } else {
            return false;
        }
        try {
            fileExists = context.exists(path, false);
        }
        catch (MavenException e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to check file existence " + path + " for profile " + profile.getId() + ": " + e.getMessage(), file.getLocation((Object)(missing ? "missing" : "exists")), (Exception)((Object)e));
            return false;
        }
        return missing != fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        return file != null;
    }
}

