/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.jline.MessageUtils;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.StyleResolver;

@Named
@Singleton
@Priority(value=10)
@Experimental
public class JLineMessageBuilderFactory
implements MessageBuilderFactory,
Prompter,
InputHandler,
OutputHandler {
    private final StyleResolver resolver = new MavenStyleResolver();

    public boolean isColorEnabled() {
        return false;
    }

    public int getTerminalWidth() {
        return MessageUtils.getTerminalWidth();
    }

    public MessageBuilder builder() {
        return new JlineMessageBuilder();
    }

    public MessageBuilder builder(int size) {
        return new JlineMessageBuilder(size);
    }

    public String readLine() throws IOException {
        return this.doPrompt(null, false);
    }

    public String readPassword() throws IOException {
        return this.doPrompt(null, true);
    }

    public List<String> readMultipleLines() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = this.readLine();
        while (line != null && !line.isEmpty()) {
            lines.add(line);
            line = this.readLine();
        }
        return lines;
    }

    public void write(String line) throws IOException {
        this.doDisplay(line);
    }

    public void writeLine(String line) throws IOException {
        this.doDisplay(line + System.lineSeparator());
    }

    public String prompt(String message) throws PrompterException {
        return this.prompt(message, null, null);
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        return this.prompt(message, null, defaultReply);
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        return this.doPrompt(message, possibleValues, defaultReply, false);
    }

    public String promptForPassword(String message) throws PrompterException {
        return this.doPrompt(message, null, null, true);
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.doDisplay(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
    }

    String doPrompt(String message, List<Object> possibleValues, String defaultReply, boolean password) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                line = this.doPrompt(formattedMessage, password);
                if (line == null && defaultReply == null) {
                    throw new IOException("EOF");
                }
            }
            catch (IOException e) {
                throw new PrompterException("Failed to prompt user", (Throwable)e);
            }
            if (line == null || line.isEmpty()) {
                line = defaultReply;
            }
            if (line == null || possibleValues == null || possibleValues.contains(line)) continue;
            try {
                this.doDisplay("Invalid selection.\n");
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || possibleValues != null && !possibleValues.contains(line));
        return line;
    }

    private String formatMessage(String message, List<Object> possibleValues, String defaultReply) {
        StringBuilder formatted = new StringBuilder(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator<Object> it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = String.valueOf(it.next());
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(' ').append(defaultReply).append(": ");
        }
        return formatted.toString();
    }

    private void doDisplay(String message) throws IOException {
        try {
            MessageUtils.terminal.writer().print(message);
            MessageUtils.terminal.flush();
        }
        catch (Exception e) {
            throw new IOException("Unable to display message", e);
        }
    }

    private String doPrompt(String message, boolean password) throws IOException {
        try {
            if (message != null) {
                if (!((String)message).endsWith("\n")) {
                    if (((String)message).endsWith(":")) {
                        message = (String)message + " ";
                    } else if (!((String)message).endsWith(": ")) {
                        message = (String)message + ": ";
                    }
                }
                int lastNl = ((String)message).lastIndexOf(10);
                String begin = ((String)message).substring(0, lastNl + 1);
                message = ((String)message).substring(lastNl + 1);
                MessageUtils.terminal.writer().print(begin);
                MessageUtils.terminal.flush();
            }
            return MessageUtils.reader.readLine((String)message, password ? Character.valueOf('*') : null);
        }
        catch (Exception e) {
            throw new IOException("Unable to prompt user", e);
        }
    }

    static class MavenStyleResolver
    extends StyleResolver {
        private final Map<String, AttributedStyle> styles = new ConcurrentHashMap<String, AttributedStyle>();

        MavenStyleResolver() {
            super(key -> {
                String v = System.getProperty("maven.style." + key);
                if (v == null) {
                    v = System.getProperty("style." + key);
                }
                return v;
            });
        }

        public AttributedStyle resolve(String spec) {
            return this.styles.computeIfAbsent(spec, this::doResolve);
        }

        public AttributedStyle resolve(String spec, String defaultSpec) {
            return this.resolve((String)(defaultSpec != null ? spec + ":-" + defaultSpec : spec));
        }

        private AttributedStyle doResolve(String spec) {
            String def = null;
            int i = spec.indexOf(":-");
            if (i != -1) {
                String[] parts = spec.split(":-");
                spec = parts[0].trim();
                def = parts[1].trim();
            }
            return super.resolve(spec, def);
        }
    }

    class JlineMessageBuilder
    implements MessageBuilder {
        final AttributedStringBuilder builder;

        JlineMessageBuilder() {
            this.builder = new AttributedStringBuilder();
        }

        JlineMessageBuilder(int size) {
            this.builder = new AttributedStringBuilder(size);
        }

        public MessageBuilder style(String style) {
            if (MessageUtils.isColorEnabled()) {
                this.builder.style(JLineMessageBuilderFactory.this.resolver.resolve(style));
            }
            return this;
        }

        public MessageBuilder resetStyle() {
            this.builder.style(AttributedStyle.DEFAULT);
            return this;
        }

        public MessageBuilder append(CharSequence cs) {
            this.builder.append(cs);
            return this;
        }

        public MessageBuilder append(CharSequence cs, int start, int end) {
            this.builder.append(cs, start, end);
            return this;
        }

        public MessageBuilder append(char c) {
            this.builder.append(c);
            return this;
        }

        public MessageBuilder setLength(int length) {
            this.builder.setLength(length);
            return this;
        }

        public String build() {
            return this.builder.toAnsi(MessageUtils.terminal);
        }

        public String toString() {
            return this.build();
        }
    }
}

