/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectRealmCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectBuildingHelper
implements ProjectBuildingHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassRealmManager classRealmManager;
    private final ProjectRealmCache projectRealmCache;
    private final MavenRepositorySystem repositorySystem;
    private final MavenPluginManager pluginManager;

    @Inject
    public DefaultProjectBuildingHelper(ClassRealmManager classRealmManager, ProjectRealmCache projectRealmCache, MavenRepositorySystem repositorySystem, MavenPluginManager pluginManager) {
        this.classRealmManager = classRealmManager;
        this.projectRealmCache = projectRealmCache;
        this.repositorySystem = repositorySystem;
        this.pluginManager = pluginManager;
    }

    @Override
    public List<ArtifactRepository> createArtifactRepositories(List<Repository> pomRepositories, List<ArtifactRepository> externalRepositories, ProjectBuildingRequest request) throws InvalidRepositoryException {
        List<ArtifactRepository> recessiveRepositories;
        List<ArtifactRepository> dominantRepositories;
        ArrayList<ArtifactRepository> internalRepositories = new ArrayList<ArtifactRepository>();
        for (Repository repository : pomRepositories) {
            internalRepositories.add(MavenRepositorySystem.buildArtifactRepository(repository));
        }
        this.repositorySystem.injectMirror(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectProxy(request.getRepositorySession(), internalRepositories);
        this.repositorySystem.injectAuthentication(request.getRepositorySession(), internalRepositories);
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)request.getRepositoryMerging())) {
            dominantRepositories = externalRepositories;
            recessiveRepositories = internalRepositories;
        } else {
            dominantRepositories = internalRepositories;
            recessiveRepositories = externalRepositories;
        }
        List<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        HashSet<String> repoIds = new HashSet<String>();
        if (dominantRepositories != null) {
            for (ArtifactRepository repository : dominantRepositories) {
                repoIds.add(repository.getId());
                artifactRepositories.add(repository);
            }
        }
        if (recessiveRepositories != null) {
            for (ArtifactRepository repository : recessiveRepositories) {
                if (!repoIds.add(repository.getId())) continue;
                artifactRepositories.add(repository);
            }
        }
        artifactRepositories = this.repositorySystem.getEffectiveRepositories(artifactRepositories);
        return artifactRepositories;
    }

    @Override
    public synchronized ProjectRealmCache.CacheRecord createProjectRealm(MavenProject project, Model model, ProjectBuildingRequest request) throws PluginResolutionException, PluginVersionResolutionException, PluginManagerException {
        ProjectRealmCache.Key projectRealmKey;
        ProjectRealmCache.CacheRecord record;
        ArrayList<Plugin> extensionPlugins = new ArrayList<Plugin>();
        Build build = model.getBuild();
        if (build != null) {
            for (Extension extension : build.getExtensions()) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(extension.getGroupId());
                plugin.setArtifactId(extension.getArtifactId());
                plugin.setVersion(extension.getVersion());
                XmlNode configuration = extension.getDelegate().getConfiguration();
                if (configuration != null) {
                    plugin.setConfiguration((Object)new Xpp3Dom(configuration));
                }
                extensionPlugins.add(plugin);
            }
            for (Plugin plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                extensionPlugins.add(plugin);
            }
        }
        if (extensionPlugins.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Extension realms for project " + model.getId() + ": (none)");
            }
            return new ProjectRealmCache.CacheRecord(null, null);
        }
        ArrayList<ClassRealm> extensionRealms = new ArrayList<ClassRealm>();
        HashMap<ClassRealm, List<String>> exportedPackages = new HashMap<ClassRealm, List<String>>();
        HashMap<Object, List<String>> exportedArtifacts = new HashMap<Object, List<String>>();
        ArrayList<org.apache.maven.artifact.Artifact> publicArtifacts = new ArrayList<org.apache.maven.artifact.Artifact>();
        for (Plugin plugin : extensionPlugins) {
            ExtensionRealmCache.CacheRecord recordRealm = this.pluginManager.setupExtensionsRealm(project, plugin, request.getRepositorySession());
            ClassRealm extensionRealm = recordRealm.getRealm();
            ExtensionDescriptor extensionDescriptor = recordRealm.getDescriptor();
            List<org.apache.maven.artifact.Artifact> artifacts = recordRealm.getArtifacts();
            extensionRealms.add(extensionRealm);
            if (extensionDescriptor != null) {
                exportedPackages.put(extensionRealm, extensionDescriptor.getExportedPackages());
                exportedArtifacts.put(extensionRealm, extensionDescriptor.getExportedArtifacts());
            }
            if (plugin.isExtensions() || artifacts.size() != 1 || artifacts.get(0).getFile() == null) continue;
            publicArtifacts.addAll(artifacts);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Extension realms for project " + model.getId() + ": " + extensionRealms);
        }
        if ((record = this.projectRealmCache.get(projectRealmKey = this.projectRealmCache.createKey(extensionRealms))) == null) {
            ClassRealm projectRealm = this.classRealmManager.createProjectRealm(model, this.toAetherArtifacts(publicArtifacts));
            LinkedHashSet exclusions = new LinkedHashSet();
            for (ClassRealm extensionRealm : extensionRealms) {
                List<String> exports;
                List excludes = (List)exportedArtifacts.get(extensionRealm);
                if (excludes != null) {
                    exclusions.addAll(excludes);
                }
                if ((exports = (List<String>)exportedPackages.get(extensionRealm)) == null || exports.isEmpty()) {
                    exports = Arrays.asList(extensionRealm.getId());
                }
                for (String export : exports) {
                    projectRealm.importFrom((ClassLoader)extensionRealm, export);
                }
            }
            ExclusionsDependencyFilter extensionArtifactFilter = null;
            if (!exclusions.isEmpty()) {
                extensionArtifactFilter = new ExclusionsDependencyFilter(exclusions);
            }
            record = this.projectRealmCache.put(projectRealmKey, projectRealm, (DependencyFilter)extensionArtifactFilter);
        }
        this.projectRealmCache.register(project, projectRealmKey, record);
        return record;
    }

    @Override
    public void selectProjectRealm(MavenProject project) {
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm == null) {
            projectRealm = this.classRealmManager.getCoreRealm();
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
    }

    private List<Artifact> toAetherArtifacts(List<org.apache.maven.artifact.Artifact> pluginArtifacts) {
        return new ArrayList<Artifact>(RepositoryUtils.toArtifacts(pluginArtifacts));
    }
}

