/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.Prompter;
import org.apache.maven.api.services.PrompterException;
import org.codehaus.plexus.PlexusContainer;

@Named
@Singleton
public class DefaultPrompter
implements Prompter {
    private static final String PROMPTER_CLASS = "org.codehaus.plexus.components.interactivity.Prompter";
    private final PlexusContainer container;

    @Inject
    public DefaultPrompter(PlexusContainer container) {
        this.container = container;
    }

    public String prompt(String message, List<String> possibleValues, String defaultReply) throws PrompterException {
        try {
            Class clazz = this.container.getContainerRealm().loadClass(PROMPTER_CLASS);
            Object instance = this.container.lookup(clazz);
            Method method = clazz.getMethod("prompt", String.class, List.class, String.class);
            return (String)method.invoke(instance, message, possibleValues, defaultReply);
        }
        catch (Exception e) {
            throw new PrompterException("Unable to call prompter", e);
        }
    }

    public String promptForPassword(String message) throws PrompterException {
        try {
            Class clazz = this.container.getContainerRealm().loadClass(PROMPTER_CLASS);
            Object instance = this.container.lookup(clazz);
            Method method = clazz.getMethod("promptForPassword", String.class);
            return (String)method.invoke(instance, message);
        }
        catch (Exception e) {
            throw new PrompterException("Unable to call prompter", e);
        }
    }

    public void showMessage(String message) throws PrompterException {
        try {
            Class clazz = this.container.getContainerRealm().loadClass(PROMPTER_CLASS);
            Object instance = this.container.lookup(clazz);
            Method method = clazz.getMethod("showMessage", String.class);
            method.invoke(instance, message);
        }
        catch (Exception e) {
            throw new PrompterException("Unable to call prompter", e);
        }
    }
}

