/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.internal.impl.PropertiesAsMap;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Typed;

@Named
@Typed
@SessionScoped
public class DefaultProjectManager
implements ProjectManager {
    private final InternalMavenSession session;
    private final ArtifactManager artifactManager;

    @Inject
    public DefaultProjectManager(InternalMavenSession session, ArtifactManager artifactManager) {
        this.session = session;
        this.artifactManager = artifactManager;
    }

    @Nonnull
    public Optional<Path> getPath(Project project) {
        Optional mainArtifact = project.getMainArtifact();
        if (mainArtifact.isPresent()) {
            return this.artifactManager.getPath((Artifact)mainArtifact.get());
        }
        return Optional.empty();
    }

    @Nonnull
    public Collection<ProducedArtifact> getAttachedArtifacts(Project project) {
        InternalMavenSession session = ((DefaultProject)project).getSession();
        List attached = Utils.map(this.getMavenProject(project).getAttachedArtifacts(), a -> (ProducedArtifact)session.getArtifact(ProducedArtifact.class, RepositoryUtils.toArtifact(a)));
        return Collections.unmodifiableCollection(attached);
    }

    public Collection<ProducedArtifact> getAllArtifacts(Project project) {
        ArrayList<ProducedArtifact> result = new ArrayList<ProducedArtifact>(2);
        result.addAll(project.getArtifacts());
        result.addAll(this.getAttachedArtifacts(project));
        return Collections.unmodifiableCollection(result);
    }

    public void attachArtifact(Project project, ProducedArtifact artifact, Path path) {
        Utils.nonNull((Object)project, (String)"project");
        Utils.nonNull((Object)artifact, (String)"artifact");
        Utils.nonNull((Object)path, (String)"path");
        if (artifact.getGroupId().isEmpty() || artifact.getArtifactId().isEmpty() || artifact.getBaseVersion().asString().isEmpty()) {
            artifact = this.session.createProducedArtifact(artifact.getGroupId().isEmpty() ? project.getGroupId() : artifact.getGroupId(), artifact.getArtifactId().isEmpty() ? project.getArtifactId() : artifact.getArtifactId(), artifact.getBaseVersion().asString().isEmpty() ? this.session.parseVersion(project.getVersion()).asString() : artifact.getBaseVersion().asString(), artifact.getClassifier(), artifact.getExtension(), null);
        }
        if (!(Objects.equals(project.getGroupId(), artifact.getGroupId()) && Objects.equals(project.getArtifactId(), artifact.getArtifactId()) && Objects.equals(project.getVersion(), artifact.getBaseVersion().asString()))) {
            throw new IllegalArgumentException("The produced artifact must have the same groupId/artifactId/version than the project it is attached to. Expecting " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + " but received " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion());
        }
        this.getMavenProject(project).addAttachedArtifact(RepositoryUtils.toArtifact(((DefaultProject)project).getSession().toArtifact((Artifact)artifact)));
        this.artifactManager.setPath(artifact, path);
    }

    public List<Path> getCompileSourceRoots(Project project, ProjectScope scope) {
        List<String> roots;
        MavenProject prj = this.getMavenProject((Project)Utils.nonNull((Object)project, (String)"project"));
        if (Utils.nonNull((Object)scope, (String)"scope") == ProjectScope.MAIN) {
            roots = prj.getCompileSourceRoots();
        } else if (scope == ProjectScope.TEST) {
            roots = prj.getTestCompileSourceRoots();
        } else {
            throw new IllegalArgumentException("Unsupported scope " + scope);
        }
        return roots.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void addCompileSourceRoot(Project project, ProjectScope scope, Path sourceRoot) {
        MavenProject prj = this.getMavenProject((Project)Utils.nonNull((Object)project, (String)"project"));
        String root = ((Path)Utils.nonNull((Object)sourceRoot, (String)"sourceRoot")).toAbsolutePath().toString();
        if (Utils.nonNull((Object)scope, (String)"scope") == ProjectScope.MAIN) {
            prj.addCompileSourceRoot(root);
        } else if (scope == ProjectScope.TEST) {
            prj.addTestCompileSourceRoot(root);
        } else {
            throw new IllegalArgumentException("Unsupported scope " + scope);
        }
    }

    public List<org.apache.maven.api.model.Resource> getResources(@Nonnull Project project, @Nonnull ProjectScope scope) {
        Project prj = (Project)Utils.nonNull((Object)project, (String)"project");
        if (Utils.nonNull((Object)scope, (String)"scope") == ProjectScope.MAIN) {
            return prj.getBuild().getResources();
        }
        if (scope == ProjectScope.TEST) {
            return prj.getBuild().getTestResources();
        }
        throw new IllegalArgumentException("Unsupported scope " + scope);
    }

    public void addResource(@Nonnull Project project, @Nonnull ProjectScope scope, @Nonnull org.apache.maven.api.model.Resource resource) {
        MavenProject prj = this.getMavenProject((Project)Utils.nonNull((Object)project, (String)"project"));
        Resource res = new Resource((org.apache.maven.api.model.Resource)Utils.nonNull((Object)resource, (String)"resource"));
        if (Utils.nonNull((Object)scope, (String)"scope") == ProjectScope.MAIN) {
            prj.addResource(res);
        } else if (scope == ProjectScope.TEST) {
            prj.addTestResource(res);
        } else {
            throw new IllegalArgumentException("Unsupported scope " + scope);
        }
    }

    public List<RemoteRepository> getRemoteProjectRepositories(Project project) {
        return Collections.unmodifiableList(new MappedList(((DefaultProject)project).getProject().getRemoteProjectRepositories(), arg_0 -> ((InternalMavenSession)this.session).getRemoteRepository(arg_0)));
    }

    public List<RemoteRepository> getRemotePluginRepositories(Project project) {
        return Collections.unmodifiableList(new MappedList(((DefaultProject)project).getProject().getRemotePluginRepositories(), arg_0 -> ((InternalMavenSession)this.session).getRemoteRepository(arg_0)));
    }

    public void setProperty(Project project, String key, String value) {
        Properties properties = this.getMavenProject(project).getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    public Map<String, String> getProperties(Project project) {
        return Collections.unmodifiableMap(new PropertiesAsMap((Map)((DefaultProject)project).getProject().getProperties()));
    }

    public Optional<Project> getExecutionProject(Project project) {
        return Optional.ofNullable(this.getMavenProject(project).getExecutionProject()).map(p -> new DefaultProject(this.session, (MavenProject)p));
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }
}

