/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.spi.ExtensibleEnumProvider;
import org.apache.maven.api.spi.LifecycleProvider;
import org.apache.maven.internal.impl.DefaultPackagingRegistry;
import org.apache.maven.internal.impl.Graph;
import org.apache.maven.internal.impl.Lifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@Singleton
public class DefaultLifecycleRegistry
implements LifecycleRegistry {
    private static final String MAVEN_PLUGINS = "org.apache.maven.plugins:";
    public static final String DEFAULT_LIFECYCLE_MODELID = "org.apache.maven:maven-core:" + DefaultLifecycleRegistry.class.getPackage().getImplementationVersion() + ":default-lifecycle-bindings";
    public static final InputLocation DEFAULT_LIFECYCLE_INPUT_LOCATION = new InputLocation(new InputSource(DEFAULT_LIFECYCLE_MODELID, null));
    private final List<LifecycleProvider> providers;

    public DefaultLifecycleRegistry() {
        this(Collections.emptyList());
    }

    @Inject
    public DefaultLifecycleRegistry(List<LifecycleProvider> providers) {
        ArrayList<LifecycleProvider> p = new ArrayList<LifecycleProvider>(providers);
        p.add(() -> List.of(new CleanLifecycle(), new DefaultLifecycle(), new SiteLifecycle()));
        this.providers = p;
        Iterator<org.apache.maven.api.Lifecycle> iterator = this.iterator();
        while (iterator.hasNext()) {
            org.apache.maven.api.Lifecycle lifecycle = iterator.next();
            HashSet set = new HashSet();
            lifecycle.allPhases().forEach(phase -> {
                if (!set.add(phase.name())) {
                    throw new IllegalArgumentException("Found duplicated phase '" + phase.name() + "' in '" + lifecycle.id() + "' lifecycle");
                }
            });
        }
    }

    public Iterator<org.apache.maven.api.Lifecycle> iterator() {
        return this.stream().toList().iterator();
    }

    public Stream<org.apache.maven.api.Lifecycle> stream() {
        return this.providers.stream().map(ExtensibleEnumProvider::provides).flatMap(Collection::stream);
    }

    public Optional<org.apache.maven.api.Lifecycle> lookup(String id) {
        return this.stream().filter(lf -> Objects.equals(id, lf.id())).findAny();
    }

    public List<String> computePhases(org.apache.maven.api.Lifecycle lifecycle) {
        Graph graph = new Graph();
        DefaultLifecycleRegistry.addPhases(graph, null, null, lifecycle.v3phases());
        List<String> allPhases = graph.visitAll();
        Collections.reverse(allPhases);
        List<String> computed = allPhases.stream().filter(s -> !s.startsWith("$")).collect(Collectors.toList());
        return computed;
    }

    private static void addPhase(Graph graph, Graph.Vertex before, Graph.Vertex after, Lifecycle.Phase phase) {
        Graph.Vertex ep0 = graph.addVertex("before:" + phase.name());
        Graph.Vertex ep1 = graph.addVertex("$$" + phase.name());
        Graph.Vertex ep2 = graph.addVertex(phase.name());
        Graph.Vertex ep3 = graph.addVertex("after:" + phase.name());
        graph.addEdge(ep0, ep1);
        graph.addEdge(ep1, ep2);
        graph.addEdge(ep2, ep3);
        if (before != null) {
            graph.addEdge(before, ep0);
        }
        if (after != null) {
            graph.addEdge(ep3, after);
        }
        phase.links().forEach(link -> {
            if (link.pointer().type() == Lifecycle.Pointer.Type.PROJECT) {
                if (link.kind() == Lifecycle.Link.Kind.AFTER) {
                    graph.addEdge(graph.addVertex(link.pointer().phase()), ep0);
                } else {
                    graph.addEdge(ep3, graph.addVertex("before:" + link.pointer().phase()));
                }
            }
        });
        DefaultLifecycleRegistry.addPhases(graph, ep1, ep2, phase.phases());
    }

    private static void addPhases(Graph graph, Graph.Vertex before, Graph.Vertex after, Collection<Lifecycle.Phase> phases) {
        Lifecycle.Phase prev = null;
        for (Lifecycle.Phase child : phases) {
            DefaultLifecycleRegistry.addPhase(graph, before, after, child);
            if (prev != null) {
                graph.addEdge(graph.addVertex("after:" + prev.name()), graph.addVertex("before:" + child.name()));
            }
            prev = child;
        }
    }

    static class CleanLifecycle
    implements org.apache.maven.api.Lifecycle {
        private static final String MAVEN_CLEAN_PLUGIN_VERSION = "3.2.0";

        CleanLifecycle() {
        }

        public String id() {
            return "clean";
        }

        public Collection<Lifecycle.Phase> phases() {
            return List.of(Lifecycles.phase("clean", Lifecycles.plugin("org.apache.maven.plugins:maven-clean-plugin:3.2.0:clean", "clean")));
        }

        public Collection<Lifecycle.Alias> aliases() {
            return List.of(Lifecycles.alias("pre-clean", "before:clean"), Lifecycles.alias("post-clean", "after:clean"));
        }
    }

    static class DefaultLifecycle
    implements org.apache.maven.api.Lifecycle {
        DefaultLifecycle() {
        }

        public String id() {
            return "default";
        }

        public Collection<Lifecycle.Phase> phases() {
            return List.of(Lifecycles.phase("all", Lifecycles.phase("validate", Lifecycles.phase("initialize")), Lifecycles.phase("build", Lifecycles.after("validate"), Lifecycles.phase("sources"), Lifecycles.phase("resources"), Lifecycles.phase("compile", Lifecycles.after("sources"), Lifecycles.dependencies("compile", "ready"), new Lifecycle.Phase[0]), Lifecycles.phase("ready", Lifecycles.after("compile"), Lifecycles.after("resources"), new Lifecycle.Phase[0]), Lifecycles.phase("package", Lifecycles.after("ready"), Lifecycles.dependencies("runtime", "package"), new Lifecycle.Phase[0])), Lifecycles.phase("verify", Lifecycles.after("validate"), Lifecycles.phase("unit-test", Lifecycles.phase("test-sources"), Lifecycles.phase("test-resources"), Lifecycles.phase("test-compile", Lifecycles.after("test-sources"), Lifecycles.after("ready"), Lifecycles.dependencies("test-only", "ready"), new Lifecycle.Phase[0]), Lifecycles.phase("test", Lifecycles.after("test-compile"), Lifecycles.after("test-resources"), Lifecycles.dependencies("test", "ready"), new Lifecycle.Phase[0])), Lifecycles.phase("integration-test")), Lifecycles.phase("install", Lifecycles.after("package"), new Lifecycle.Phase[0]), Lifecycles.phase("deploy", Lifecycles.after("package"), new Lifecycle.Phase[0])));
        }

        public Collection<Lifecycle.Phase> v3phases() {
            return List.of(Lifecycles.phase("all", Lifecycles.phase("initialize", Lifecycles.phase("validate")), Lifecycles.phase("build", Lifecycles.phase("sources"), Lifecycles.phase("resources"), Lifecycles.phase("compile"), Lifecycles.phase("ready"), Lifecycles.phase("test-sources"), Lifecycles.phase("test-resources"), Lifecycles.phase("test-compile"), Lifecycles.phase("test"), Lifecycles.phase("unit-test"), Lifecycles.phase("package")), Lifecycles.phase("verify", Lifecycles.phase("integration-test")), Lifecycles.phase("install"), Lifecycles.phase("deploy")));
        }

        public Collection<Lifecycle.Alias> aliases() {
            return List.of(Lifecycles.alias("generate-sources", "sources"), Lifecycles.alias("process-sources", "after:sources"), Lifecycles.alias("generate-resources", "resources"), Lifecycles.alias("process-resources", "after:resources"), Lifecycles.alias("process-classes", "after:compile"), Lifecycles.alias("generate-test-sources", "test-sources"), Lifecycles.alias("process-test-sources", "after:test-sources"), Lifecycles.alias("generate-test-resources", "test-resources"), Lifecycles.alias("process-test-resources", "after:test-resources"), Lifecycles.alias("process-test-classes", "after:test-compile"), Lifecycles.alias("prepare-package", "before:package"), Lifecycles.alias("pre-integration-test", "before:integration-test"), Lifecycles.alias("post-integration-test", "after:integration-test"));
        }
    }

    static class SiteLifecycle
    implements org.apache.maven.api.Lifecycle {
        private static final String MAVEN_SITE_PLUGIN_VERSION = "3.12.1";
        private static final String MAVEN_SITE_PLUGIN = "org.apache.maven.plugins:maven-site-plugin:3.12.1:";
        private static final String PHASE_SITE = "site";
        private static final String PHASE_SITE_DEPLOY = "site-deploy";

        SiteLifecycle() {
        }

        public String id() {
            return PHASE_SITE;
        }

        public Collection<Lifecycle.Phase> phases() {
            return List.of(Lifecycles.phase(PHASE_SITE, Lifecycles.plugin("org.apache.maven.plugins:maven-site-plugin:3.12.1:site", PHASE_SITE)), Lifecycles.phase(PHASE_SITE_DEPLOY, Lifecycles.after(PHASE_SITE), Lifecycles.plugin("org.apache.maven.plugins:maven-site-plugin:3.12.1:deploy", PHASE_SITE_DEPLOY)));
        }

        public Collection<Lifecycle.Alias> aliases() {
            return List.of(Lifecycles.alias("pre-site", "before:site"), Lifecycles.alias("post-site", "after:site"));
        }
    }

    @Singleton
    @Named(value="site")
    static class SiteLifecycleProvider
    extends BaseLifecycleProvider {
        SiteLifecycleProvider() {
            super("site");
        }
    }

    @Singleton
    @Named(value="default")
    static class DefaultLifecycleProvider
    extends BaseLifecycleProvider {
        DefaultLifecycleProvider() {
            super("default");
        }
    }

    @Singleton
    @Named(value="clean")
    static class CleanLifecycleProvider
    extends BaseLifecycleProvider {
        CleanLifecycleProvider() {
            super("clean");
        }
    }

    static abstract class BaseLifecycleProvider
    implements Provider<Lifecycle> {
        @Inject
        private PlexusContainer lookup;
        private final String name;

        BaseLifecycleProvider(String name) {
            this.name = name;
        }

        public Lifecycle get() {
            try {
                LifecycleRegistry registry = (LifecycleRegistry)this.lookup.lookup(LifecycleRegistry.class);
                return new WrappedLifecycle(registry, (org.apache.maven.api.Lifecycle)registry.require(this.name));
            }
            catch (ComponentLookupException e) {
                throw new LookupException((Exception)((Object)e));
            }
        }
    }

    static class WrappedLifecycle
    extends Lifecycle {
        WrappedLifecycle(LifecycleRegistry registry, org.apache.maven.api.Lifecycle lifecycle) {
            super(registry, lifecycle);
        }
    }

    @Named
    @Singleton
    public static class LifecycleWrapperProvider
    implements LifecycleProvider {
        private final PlexusContainer container;

        @Inject
        public LifecycleWrapperProvider(PlexusContainer container) {
            this.container = container;
        }

        public Collection<org.apache.maven.api.Lifecycle> provides() {
            try {
                Map all = this.container.lookupMap(Lifecycle.class);
                return all.keySet().stream().filter(id -> !"clean".equals(id) && !"default".equals(id) && !"site".equals(id)).map(id -> this.wrap((Lifecycle)all.get(id))).collect(Collectors.toList());
            }
            catch (ComponentLookupException e) {
                throw new LookupException((Exception)((Object)e));
            }
        }

        private org.apache.maven.api.Lifecycle wrap(final Lifecycle lifecycle) {
            return new org.apache.maven.api.Lifecycle(){

                public String id() {
                    return lifecycle.getId();
                }

                public Collection<Lifecycle.Phase> phases() {
                    List<String> names = lifecycle.getPhases();
                    ArrayList<Lifecycle.Phase> phases = new ArrayList<Lifecycle.Phase>();
                    for (int i = 0; i < names.size(); ++i) {
                        final String name = names.get(i);
                        final String prev = i > 0 ? names.get(i - 1) : null;
                        phases.add(new Lifecycle.Phase(){

                            public String name() {
                                return name;
                            }

                            public List<Lifecycle.Phase> phases() {
                                return List.of();
                            }

                            public Stream<Lifecycle.Phase> allPhases() {
                                return Stream.concat(Stream.of(this), this.phases().stream().flatMap(Lifecycle.Phase::allPhases));
                            }

                            public List<Plugin> plugins() {
                                LifecyclePhase phase;
                                Map<String, LifecyclePhase> lfPhases = lifecycle.getDefaultLifecyclePhases();
                                LifecyclePhase lifecyclePhase = phase = lfPhases != null ? lfPhases.get(name) : null;
                                if (phase != null) {
                                    LinkedHashMap<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
                                    DefaultPackagingRegistry.parseLifecyclePhaseDefinitions(plugins, name, phase);
                                    return plugins.values().stream().toList();
                                }
                                return List.of();
                            }

                            public Collection<Lifecycle.Link> links() {
                                if (prev == null) {
                                    return List.of();
                                }
                                return List.of(new Lifecycle.Link(){

                                    public Lifecycle.Link.Kind kind() {
                                        return Lifecycle.Link.Kind.AFTER;
                                    }

                                    public Lifecycle.Pointer pointer() {
                                        return new Lifecycle.Pointer(){

                                            public String phase() {
                                                return prev;
                                            }

                                            public Lifecycle.Pointer.Type type() {
                                                return Lifecycle.Pointer.Type.PROJECT;
                                            }
                                        };
                                    }
                                });
                            }
                        });
                    }
                    return phases;
                }

                public Collection<Lifecycle.Alias> aliases() {
                    return Collections.emptyList();
                }
            };
        }
    }
}

