/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc.goals;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.goals.ConfiguredGoalSupport;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;

@Singleton
@Named(value="decrypt")
public class Decrypt
extends ConfiguredGoalSupport {
    @Inject
    public Decrypt(MessageBuilderFactory messageBuilderFactory, SecDispatcher secDispatcher) {
        super(messageBuilderFactory, secDispatcher);
    }

    @Override
    protected int doExecute(EncryptContext context) throws Exception {
        String encrypted = context.reader.readLine("Enter the password to decrypt: ");
        if (this.secDispatcher.isAnyEncryptedString(encrypted)) {
            context.terminal.writer().println(this.secDispatcher.decrypt(encrypted));
            return 0;
        }
        context.terminal.writer().println(this.messageBuilderFactory.builder().error((Object)"Malformed encrypted string"));
        return 2;
    }
}

