/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.mvnenc.EncryptOptions;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.Goal;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;

public class EncryptInvoker
extends LookupInvoker<EncryptContext> {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int BAD_OPERATION = 2;
    public static final int CANCELED = 3;

    public EncryptInvoker(ProtoLookup protoLookup) {
        super(protoLookup);
    }

    @Override
    protected int execute(EncryptContext context) throws Exception {
        return this.doExecute(context);
    }

    @Override
    protected EncryptContext createContext(InvokerRequest invokerRequest) {
        return new EncryptContext(invokerRequest);
    }

    @Override
    protected void lookup(EncryptContext context) {
        context.goals = context.lookup.lookupMap(Goal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(EncryptContext context) throws Exception {
        try {
            context.header = new ArrayList<AttributedString>();
            context.style = new AttributedStyle();
            context.addInHeader(context.style.italic().bold().foreground(Colors.rgbColor((String)"green").intValue()), "Maven Encryption " + CLIReportingUtils.showVersionMinimal());
            context.addInHeader("Tool for secure password management on workstations.");
            context.addInHeader("This tool is part of Apache Maven 4 distribution.");
            context.addInHeader("");
            Thread executeThread = Thread.currentThread();
            context.terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            context.reader = LineReaderBuilder.builder().terminal(context.terminal).build();
            EncryptOptions options = (EncryptOptions)context.invokerRequest.options();
            if (options.goals().isEmpty() || ((List)options.goals().get()).size() != 1) {
                int n = this.badGoalsErrorMessage("No goal or multiple goals specified, specify only one goal.", context);
                return n;
            }
            String goalName = (String)((List)options.goals().get()).get(0);
            Goal goal = context.goals.get(goalName);
            if (goal == null) {
                int n = this.badGoalsErrorMessage("Unknown goal: " + goalName, context);
                return n;
            }
            int n = goal.execute(context);
            return n;
        }
        catch (InterruptedIOException | InterruptedException | UserInterruptException e) {
            context.logger.error("Goal canceled by user.");
            int n = 3;
            return n;
        }
        catch (Exception e) {
            if (context.invokerRequest.options().showErrors().orElse(false).booleanValue()) {
                context.logger.error(e.getMessage(), (Throwable)e);
            } else {
                context.logger.error(e.getMessage());
            }
            int n = 1;
            return n;
        }
        finally {
            context.terminal.writer().flush();
        }
    }

    protected int badGoalsErrorMessage(String message, EncryptContext context) {
        context.logger.error(message);
        context.logger.error("Supported goals are: " + String.join((CharSequence)", ", context.goals.keySet()));
        context.logger.error("Use -h to display help.");
        return 2;
    }
}

