/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.SettingsBuilderRequest;
import org.apache.maven.api.services.SettingsBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.ToolchainsBuilder;
import org.apache.maven.api.services.ToolchainsBuilderRequest;
import org.apache.maven.api.services.ToolchainsBuilderResult;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.cling.event.ExecutionEventLogger;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.Utils;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cling.transfer.QuietMavenTransferListener;
import org.apache.maven.cling.transfer.SimplexTransferListener;
import org.apache.maven.cling.transfer.Slf4jMavenTransferListener;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.logging.LoggingExecutionListener;
import org.apache.maven.logging.MavenTransferListener;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferListener;

public abstract class MavenInvoker<C extends MavenContext>
extends LookupInvoker<C> {
    protected static final Pattern NEXT_LINE = Pattern.compile("\r?\n");
    protected static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    protected static final String ANSI_RESET = "\u001b[m";

    public MavenInvoker(ProtoLookup protoLookup) {
        super(protoLookup);
    }

    @Override
    protected int execute(C context) throws Exception {
        MavenExecutionRequest request = this.prepareMavenExecutionRequest();
        this.toolchains(context, request);
        this.populateRequest(context, ((MavenContext)context).lookup, request);
        return this.doExecute(context, request);
    }

    protected MavenExecutionRequest prepareMavenExecutionRequest() throws Exception {
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequest.setRepositoryCache((RepositoryCache)new DefaultRepositoryCache());
        mavenExecutionRequest.setInteractiveMode(true);
        mavenExecutionRequest.setCacheTransferError(false);
        mavenExecutionRequest.setIgnoreInvalidArtifactDescriptor(true);
        mavenExecutionRequest.setIgnoreMissingArtifactDescriptor(true);
        mavenExecutionRequest.setRecursive(true);
        mavenExecutionRequest.setReactorFailureBehavior("FAIL_FAST");
        mavenExecutionRequest.setStartInstant(MonotonicClock.now());
        mavenExecutionRequest.setLoggingLevel(1);
        mavenExecutionRequest.setDegreeOfConcurrency(1);
        mavenExecutionRequest.setBuilderId("singlethreaded");
        return mavenExecutionRequest;
    }

    @Override
    protected void lookup(C context) throws Exception {
        ((MavenContext)context).eventSpyDispatcher = (EventSpyDispatcher)((MavenContext)context).lookup.lookup(EventSpyDispatcher.class);
        ((MavenContext)context).maven = (Maven)((MavenContext)context).lookup.lookup(Maven.class);
    }

    @Override
    protected void init(C context) throws Exception {
        super.init(context);
        InvokerRequest invokerRequest = ((MavenContext)context).invokerRequest;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("plexus", ((MavenContext)context).lookup.lookup(PlexusContainer.class));
        data.put("workingDirectory", invokerRequest.cwd().toString());
        data.put("systemProperties", Utils.toProperties(((MavenContext)context).protoSession.getSystemProperties()));
        data.put("userProperties", Utils.toProperties(((MavenContext)context).protoSession.getUserProperties()));
        data.put("versionProperties", CLIReportingUtils.getBuildProperties());
        ((MavenContext)context).eventSpyDispatcher.init(() -> data);
    }

    @Override
    protected void postCommands(C context) throws Exception {
        super.postCommands(context);
        InvokerRequest invokerRequest = ((MavenContext)context).invokerRequest;
        MavenOptions options = (MavenOptions)invokerRequest.options();
        Logger logger = ((MavenContext)context).logger;
        if (options.relaxedChecksums().orElse(false).booleanValue()) {
            logger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if (options.strictChecksums().orElse(false).booleanValue()) {
            logger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    @Override
    protected void customizeSettingsRequest(C context, SettingsBuilderRequest settingsBuilderRequest) throws Exception {
        if (((MavenContext)context).eventSpyDispatcher != null) {
            ((MavenContext)context).eventSpyDispatcher.onEvent((Object)settingsBuilderRequest);
        }
    }

    @Override
    protected void customizeSettingsResult(C context, SettingsBuilderResult settingsBuilderResult) throws Exception {
        if (((MavenContext)context).eventSpyDispatcher != null) {
            ((MavenContext)context).eventSpyDispatcher.onEvent((Object)settingsBuilderResult);
        }
    }

    protected void toolchains(C context, MavenExecutionRequest request) throws Exception {
        Path userToolchainsFile = null;
        if (((MavenContext)context).invokerRequest.options().altUserToolchains().isPresent()) {
            userToolchainsFile = (Path)((MavenContext)context).cwdResolver.apply((String)((MavenContext)context).invokerRequest.options().altUserToolchains().get());
            if (!Files.isRegularFile(userToolchainsFile, new LinkOption[0])) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + userToolchainsFile);
            }
        } else {
            String userToolchainsFileStr = (String)((MavenContext)context).protoSession.getUserProperties().get("maven.user.toolchains");
            if (userToolchainsFileStr != null) {
                userToolchainsFile = (Path)((MavenContext)context).cwdResolver.apply(userToolchainsFileStr);
            }
        }
        Path installationToolchainsFile = null;
        if (((MavenContext)context).invokerRequest.options().altInstallationToolchains().isPresent()) {
            installationToolchainsFile = (Path)((MavenContext)context).cwdResolver.apply((String)((MavenContext)context).invokerRequest.options().altInstallationToolchains().get());
            if (!Files.isRegularFile(installationToolchainsFile, new LinkOption[0])) {
                throw new FileNotFoundException("The specified installation toolchains file does not exist: " + installationToolchainsFile);
            }
        } else {
            String installationToolchainsFileStr = (String)((MavenContext)context).protoSession.getUserProperties().get("maven.installation.toolchains");
            if (installationToolchainsFileStr != null) {
                installationToolchainsFile = (Path)((MavenContext)context).cwdResolver.apply(installationToolchainsFileStr);
            }
        }
        request.setInstallationToolchainsFile(installationToolchainsFile != null ? installationToolchainsFile.toFile() : null);
        request.setUserToolchainsFile(userToolchainsFile != null ? userToolchainsFile.toFile() : null);
        ToolchainsBuilderRequest toolchainsRequest = ToolchainsBuilderRequest.builder().session(((MavenContext)context).protoSession).installationToolchainsSource(installationToolchainsFile != null && Files.isRegularFile(installationToolchainsFile, new LinkOption[0]) ? Source.fromPath((Path)installationToolchainsFile) : null).userToolchainsSource(userToolchainsFile != null && Files.isRegularFile(userToolchainsFile, new LinkOption[0]) ? Source.fromPath((Path)userToolchainsFile) : null).build();
        ((MavenContext)context).eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        ((MavenContext)context).logger.debug("Reading installation toolchains from '" + installationToolchainsFile + "'");
        ((MavenContext)context).logger.debug("Reading user toolchains from '" + userToolchainsFile + "'");
        ToolchainsBuilderResult toolchainsResult = ((ToolchainsBuilder)((MavenContext)context).lookup.lookup(ToolchainsBuilder.class)).build(toolchainsRequest);
        ((MavenContext)context).eventSpyDispatcher.onEvent((Object)toolchainsResult);
        ((MavenExecutionRequestPopulator)((MavenContext)context).lookup.lookup(MavenExecutionRequestPopulator.class)).populateFromToolchains(request, new PersistedToolchains(toolchainsResult.getEffectiveToolchains()));
        if (!toolchainsResult.getProblems().isEmpty()) {
            ((MavenContext)context).logger.warn("");
            ((MavenContext)context).logger.warn("Some problems were encountered while building the effective toolchains");
            for (BuilderProblem problem : toolchainsResult.getProblems()) {
                ((MavenContext)context).logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            ((MavenContext)context).logger.warn("");
        }
    }

    @Override
    protected void populateRequest(C context, Lookup lookup, MavenExecutionRequest request) throws Exception {
        int degreeOfConcurrency;
        super.populateRequest(context, lookup, request);
        if (((MavenContext)context).invokerRequest.rootDirectory().isEmpty()) {
            request.setMultiModuleProjectDirectory(((MavenContext)context).invokerRequest.topDirectory().toFile());
            request.setRootDirectory(((MavenContext)context).invokerRequest.topDirectory());
        }
        MavenOptions options = (MavenOptions)((MavenContext)context).invokerRequest.options();
        request.setNoSnapshotUpdates(options.suppressSnapshotUpdates().orElse(false).booleanValue());
        request.setGoals(options.goals().orElse(List.of()));
        request.setReactorFailureBehavior(this.determineReactorFailureBehaviour(context));
        request.setRecursive(options.nonRecursive().orElse(!request.isRecursive()) == false);
        request.setOffline(options.offline().orElse(request.isOffline()).booleanValue());
        request.setUpdateSnapshots(options.updateSnapshots().orElse(false).booleanValue());
        request.setGlobalChecksumPolicy(this.determineGlobalChecksumPolicy(context));
        Path pom = this.determinePom(context, lookup);
        if (pom != null) {
            request.setPom(pom.toFile());
            if (pom.getParent() != null) {
                request.setBaseDirectory(pom.getParent().toFile());
            }
            if (((MavenContext)context).invokerRequest.rootDirectory().isEmpty()) {
                Path rootDirectory = Utils.findMandatoryRoot(((MavenContext)context).invokerRequest.topDirectory());
                request.setMultiModuleProjectDirectory(rootDirectory.toFile());
                request.setRootDirectory(rootDirectory);
            }
        }
        request.setTransferListener(this.determineTransferListener(context, options.noTransferProgress().orElse(false)));
        request.setExecutionListener(this.determineExecutionListener(context));
        request.setResumeFrom((String)options.resumeFrom().orElse(null));
        request.setResume(options.resume().orElse(false).booleanValue());
        request.setMakeBehavior(this.determineMakeBehavior(context));
        request.setCacheNotFound(options.cacheArtifactNotFound().orElse(true).booleanValue());
        request.setCacheTransferError(false);
        if (options.strictArtifactDescriptorPolicy().orElse(false).booleanValue()) {
            request.setIgnoreMissingArtifactDescriptor(false);
            request.setIgnoreInvalidArtifactDescriptor(false);
        } else {
            request.setIgnoreMissingArtifactDescriptor(true);
            request.setIgnoreInvalidArtifactDescriptor(true);
        }
        request.setIgnoreTransitiveRepositories(options.ignoreTransitiveRepositories().orElse(false).booleanValue());
        this.performProjectActivation(context, request.getProjectActivation());
        this.performProfileActivation(context, request.getProfileActivation());
        if (options.threads().isPresent() && (degreeOfConcurrency = this.calculateDegreeOfConcurrency((String)options.threads().get())) > 1) {
            request.setBuilderId("multithreaded");
            request.setDegreeOfConcurrency(degreeOfConcurrency);
        }
        if (options.builder().isPresent()) {
            request.setBuilderId((String)options.builder().get());
        }
    }

    protected Path determinePom(C context, Lookup lookup) {
        ModelProcessor modelProcessor;
        Path current = ((MavenContext)context).invokerRequest.cwd();
        MavenOptions options = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (options.alternatePomFile().isPresent()) {
            current = (Path)((MavenContext)context).cwdResolver.apply((String)options.alternatePomFile().get());
        }
        if ((modelProcessor = (ModelProcessor)lookup.lookupOptional(ModelProcessor.class).orElse(null)) != null) {
            return modelProcessor.locateExistingPom(current);
        }
        return Files.isRegularFile(current, new LinkOption[0]) ? current : null;
    }

    protected String determineReactorFailureBehaviour(C context) {
        MavenOptions mavenOptions = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (mavenOptions.failFast().isPresent()) {
            return "FAIL_FAST";
        }
        if (mavenOptions.failAtEnd().isPresent()) {
            return "FAIL_AT_END";
        }
        if (mavenOptions.failNever().isPresent()) {
            return "FAIL_NEVER";
        }
        return "FAIL_FAST";
    }

    protected String determineGlobalChecksumPolicy(C context) {
        MavenOptions mavenOptions = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (mavenOptions.strictChecksums().orElse(false).booleanValue()) {
            return "fail";
        }
        if (mavenOptions.relaxedChecksums().orElse(false).booleanValue()) {
            return "warn";
        }
        return null;
    }

    protected ExecutionListener determineExecutionListener(C context) {
        ExecutionEventLogger listener = new ExecutionEventLogger(((MavenContext)context).invokerRequest.messageBuilderFactory());
        if (((MavenContext)context).eventSpyDispatcher != null) {
            listener = ((MavenContext)context).eventSpyDispatcher.chainListener((ExecutionListener)listener);
        }
        return new LoggingExecutionListener((ExecutionListener)listener, this.determineBuildEventListener(context));
    }

    protected TransferListener determineTransferListener(C context, boolean noTransferProgress) {
        boolean quietCI;
        boolean quiet = ((MavenContext)context).invokerRequest.options().quiet().orElse(false);
        boolean logFile = ((MavenContext)context).invokerRequest.options().logFile().isPresent();
        boolean runningOnCI = this.isRunningOnCI(context);
        boolean bl = quietCI = runningOnCI && ((MavenContext)context).invokerRequest.options().forceInteractive().orElse(false) == false;
        AbstractTransferListener delegate = quiet || noTransferProgress || quietCI ? new QuietMavenTransferListener() : (((MavenContext)context).interactive && !logFile ? new SimplexTransferListener((TransferListener)new ConsoleMavenTransferListener(((MavenContext)context).invokerRequest.messageBuilderFactory(), ((MavenContext)context).terminal.writer(), ((MavenContext)context).invokerRequest.options().verbose().orElse(false))) : new Slf4jMavenTransferListener());
        return new MavenTransferListener((TransferListener)delegate, this.determineBuildEventListener(context));
    }

    protected String determineMakeBehavior(C context) {
        MavenOptions mavenOptions = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (mavenOptions.alsoMake().isPresent() && mavenOptions.alsoMakeDependents().isEmpty()) {
            return "make-upstream";
        }
        if (mavenOptions.alsoMake().isEmpty() && mavenOptions.alsoMakeDependents().isPresent()) {
            return "make-downstream";
        }
        if (mavenOptions.alsoMake().isPresent() && mavenOptions.alsoMakeDependents().isPresent()) {
            return "make-both";
        }
        return null;
    }

    protected void performProjectActivation(C context, ProjectActivation projectActivation) {
        MavenOptions mavenOptions = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (mavenOptions.projects().isPresent() && !((List)mavenOptions.projects().get()).isEmpty()) {
            List optionValues = (List)mavenOptions.projects().get();
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String selector = token.trim();
                    boolean active = true;
                    if (!selector.isEmpty()) {
                        if (selector.charAt(0) == '-' || selector.charAt(0) == '!') {
                            active = false;
                            selector = selector.substring(1);
                        } else if (token.charAt(0) == '+') {
                            selector = selector.substring(1);
                        }
                    }
                    boolean optional = false;
                    if (!selector.isEmpty() && selector.charAt(0) == '?') {
                        optional = true;
                        selector = selector.substring(1);
                    }
                    projectActivation.addProjectActivation(selector, active, optional);
                }
            }
        }
    }

    protected void performProfileActivation(C context, ProfileActivation profileActivation) {
        MavenOptions mavenOptions = (MavenOptions)((MavenContext)context).invokerRequest.options();
        if (mavenOptions.activatedProfiles().isPresent() && !((List)mavenOptions.activatedProfiles().get()).isEmpty()) {
            List optionValues = (List)mavenOptions.activatedProfiles().get();
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String profileId = token.trim();
                    boolean active = true;
                    if (!profileId.isEmpty()) {
                        if (profileId.charAt(0) == '-' || profileId.charAt(0) == '!') {
                            active = false;
                            profileId = profileId.substring(1);
                        } else if (token.charAt(0) == '+') {
                            profileId = profileId.substring(1);
                        }
                    }
                    boolean optional = false;
                    if (!profileId.isEmpty() && profileId.charAt(0) == '?') {
                        optional = true;
                        profileId = profileId.substring(1);
                    }
                    profileActivation.addProfileActivation(profileId, active, optional);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(C context, MavenExecutionRequest request) throws Exception {
        MavenExecutionResult result;
        ((MavenContext)context).eventSpyDispatcher.onEvent((Object)request);
        try {
            result = ((MavenContext)context).maven.execute(request);
            ((MavenContext)context).eventSpyDispatcher.onEvent((Object)result);
        }
        finally {
            ((MavenContext)context).eventSpyDispatcher.close();
        }
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            ArrayList<MavenProject> failedProjects = new ArrayList<MavenProject>();
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(context, summary, references, "");
                if (!(throwable instanceof LifecycleExecutionException)) continue;
                failedProjects.add(((LifecycleExecutionException)throwable).getProject());
            }
            ((MavenContext)context).logger.error("");
            if (!((MavenContext)context).invokerRequest.options().showErrors().orElse(false).booleanValue()) {
                ((MavenContext)context).logger.error("To see the full stack trace of the errors, re-run Maven with the '" + MessageUtils.builder().strong((Object)"-e") + "' switch");
            }
            if (!((MavenContext)context).invokerRequest.options().verbose().orElse(false).booleanValue()) {
                ((MavenContext)context).logger.error("Re-run Maven using the '" + MessageUtils.builder().strong((Object)"-X") + "' switch to enable verbose output");
            }
            if (!references.isEmpty()) {
                ((MavenContext)context).logger.error("");
                ((MavenContext)context).logger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    ((MavenContext)context).logger.error(MessageUtils.builder().strong(entry.getValue()) + " " + (String)entry.getKey());
                }
            }
            if (result.canResume()) {
                this.logBuildResumeHint(context, "mvn [args] -r");
            } else if (!failedProjects.isEmpty()) {
                List sortedProjects = result.getTopologicallySortedProjects();
                failedProjects.sort(Comparator.comparing(sortedProjects::indexOf));
                MavenProject mavenProject = (MavenProject)failedProjects.get(0);
                if (!mavenProject.equals(sortedProjects.get(0))) {
                    String resumeFromSelector = this.getResumeFromSelector(sortedProjects, mavenProject);
                    this.logBuildResumeHint(context, "mvn [args] -rf " + resumeFromSelector);
                }
            }
            if (((MavenOptions)((MavenContext)context).invokerRequest.options()).failNever().orElse(false).booleanValue()) {
                ((MavenContext)context).logger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected void logBuildResumeHint(C context, String resumeBuildHint) {
        ((MavenContext)context).logger.error("");
        ((MavenContext)context).logger.error("After correcting the problems, you can resume the build with the command");
        ((MavenContext)context).logger.error(MessageUtils.builder().a((CharSequence)"  ").strong((Object)resumeBuildHint).toString());
    }

    protected String getResumeFromSelector(List<MavenProject> mavenProjects, MavenProject firstFailedProject) {
        boolean hasOverlappingArtifactId;
        boolean bl = hasOverlappingArtifactId = mavenProjects.stream().filter(project -> firstFailedProject.getArtifactId().equals(project.getArtifactId())).count() > 1L;
        if (hasOverlappingArtifactId) {
            return firstFailedProject.getGroupId() + ":" + firstFailedProject.getArtifactId();
        }
        return ":" + firstFailedProject.getArtifactId();
    }

    protected void logSummary(C context, ExceptionSummary summary, Map<String, String> references, String indent) {
        String referenceKey = "";
        if (summary.getReference() != null && !summary.getReference().isEmpty()) {
            referenceKey = references.computeIfAbsent(summary.getReference(), k -> "[Help " + (references.size() + 1) + "]");
        }
        Object msg = summary.getMessage();
        if (!referenceKey.isEmpty()) {
            msg = ((String)msg).indexOf(10) < 0 ? (String)msg + " -> " + MessageUtils.builder().strong((Object)referenceKey) : (String)msg + "\n-> " + MessageUtils.builder().strong((Object)referenceKey);
        }
        String[] lines = NEXT_LINE.split((CharSequence)msg);
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = (String)indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (((MavenContext)context).invokerRequest.options().showErrors().orElse(false).booleanValue() || summary.getException() instanceof InternalErrorException)) {
                ((MavenContext)context).logger.error(line, summary.getException());
            } else {
                ((MavenContext)context).logger.error(line);
            }
            currentColor = nextColor;
        }
        indent = (String)indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(context, child, references, (String)indent);
        }
    }
}

