/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.List;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;

@Experimental
public interface VersionRangeResolverRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public ArtifactCoordinates getArtifactCoordinates();

    @Nullable
    public List<RemoteRepository> getRepositories();

    @Nonnull
    public static VersionRangeResolverRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinates artifactCoordinates) {
        return VersionRangeResolverRequest.build(session, artifactCoordinates, null);
    }

    @Nonnull
    public static VersionRangeResolverRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinates artifactCoordinates, @Nullable List<RemoteRepository> repositories) {
        return VersionRangeResolverRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).artifactCoordinates(BaseRequest.nonNull(artifactCoordinates, "artifactCoordinates cannot be null")).repositories(repositories).build();
    }

    @Nonnull
    public static VersionResolverRequestBuilder builder() {
        return new VersionResolverRequestBuilder();
    }

    @NotThreadSafe
    public static class VersionResolverRequestBuilder {
        Session session;
        ArtifactCoordinates artifactCoordinates;
        List<RemoteRepository> repositories;

        public VersionResolverRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public VersionResolverRequestBuilder artifactCoordinates(ArtifactCoordinates artifactCoordinates) {
            this.artifactCoordinates = artifactCoordinates;
            return this;
        }

        public VersionResolverRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public VersionRangeResolverRequest build() {
            return new DefaultVersionResolverRequest(this.session, this.artifactCoordinates, this.repositories);
        }

        private static class DefaultVersionResolverRequest
        extends BaseRequest<Session>
        implements VersionRangeResolverRequest {
            private final ArtifactCoordinates artifactCoordinates;
            private final List<RemoteRepository> repositories;

            DefaultVersionResolverRequest(@Nonnull Session session, @Nonnull ArtifactCoordinates artifactCoordinates, @Nullable List<RemoteRepository> repositories) {
                super(session);
                this.artifactCoordinates = artifactCoordinates;
                this.repositories = repositories;
            }

            @Override
            @Nonnull
            public ArtifactCoordinates getArtifactCoordinates() {
                return this.artifactCoordinates;
            }

            @Override
            @Nullable
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }
        }
    }
}

