/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Source;

class PathSource
implements ModelSource {
    private final Path path;
    private final String location;

    PathSource(Path path) {
        this(path, null);
    }

    PathSource(Path path, String location) {
        this.path = path.normalize();
        this.location = location != null ? location : this.path.toString();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Source resolve(String relative) {
        return new PathSource(this.path.resolve(relative));
    }

    @Override
    public ModelSource resolve(ModelSource.ModelLocator locator, String relative) {
        String norm = relative.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        Path path = this.getPath().getParent().resolve(norm);
        Path relatedPom = locator.locateExistingPom(path);
        if (relatedPom != null) {
            return new PathSource(relatedPom);
        }
        return null;
    }

    public boolean equals(Object o) {
        return this == o || o.getClass() == this.getClass() && Objects.equals(this.path, ((PathSource)o).path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return "PathSource[location='" + this.location + "', path=" + this.path + "]";
    }
}

