/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;

@Experimental
@Immutable
public interface ModelBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public ModelSource getSource();

    @Nonnull
    public RequestType getRequestType();

    public boolean isLocationTracking();

    public boolean isRecursive();

    @Nonnull
    public Collection<Profile> getProfiles();

    @Nonnull
    public List<String> getActiveProfileIds();

    @Nonnull
    public List<String> getInactiveProfileIds();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public RepositoryMerging getRepositoryMerging();

    @Nullable
    public List<RemoteRepository> getRepositories();

    @Nullable
    public ModelTransformer getLifecycleBindingsInjector();

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull ModelBuilderRequest request, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder(BaseRequest.nonNull(request, "request cannot be null")).source(BaseRequest.nonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).source(BaseRequest.nonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull Path path) {
        return ModelBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).source(ModelSource.fromPath(path)).build();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder() {
        return new ModelBuilderRequestBuilder();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder(ModelBuilderRequest request) {
        return new ModelBuilderRequestBuilder(request);
    }

    @NotThreadSafe
    public static class ModelBuilderRequestBuilder {
        Session session;
        RequestType requestType;
        boolean locationTracking;
        boolean recursive;
        ModelSource source;
        Collection<Profile> profiles;
        List<String> activeProfileIds;
        List<String> inactiveProfileIds;
        Map<String, String> systemProperties;
        Map<String, String> userProperties;
        RepositoryMerging repositoryMerging;
        List<RemoteRepository> repositories;
        ModelTransformer lifecycleBindingsInjector;

        ModelBuilderRequestBuilder() {
        }

        ModelBuilderRequestBuilder(ModelBuilderRequest request) {
            this.session = request.getSession();
            this.requestType = request.getRequestType();
            this.locationTracking = request.isLocationTracking();
            this.recursive = request.isRecursive();
            this.source = request.getSource();
            this.profiles = request.getProfiles();
            this.activeProfileIds = request.getActiveProfileIds();
            this.inactiveProfileIds = request.getInactiveProfileIds();
            this.systemProperties = request.getSystemProperties();
            this.userProperties = request.getUserProperties();
            this.repositoryMerging = request.getRepositoryMerging();
            this.repositories = request.getRepositories();
            this.lifecycleBindingsInjector = request.getLifecycleBindingsInjector();
        }

        public ModelBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ModelBuilderRequestBuilder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public ModelBuilderRequestBuilder locationTracking(boolean locationTracking) {
            this.locationTracking = locationTracking;
            return this;
        }

        public ModelBuilderRequestBuilder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public ModelBuilderRequestBuilder source(ModelSource source) {
            this.source = source;
            return this;
        }

        public ModelBuilderRequestBuilder profiles(List<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        public ModelBuilderRequestBuilder activeProfileIds(List<String> activeProfileIds) {
            this.activeProfileIds = activeProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder inactiveProfileIds(List<String> inactiveProfileIds) {
            this.inactiveProfileIds = inactiveProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
            return this;
        }

        public ModelBuilderRequestBuilder userProperties(Map<String, String> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public ModelBuilderRequestBuilder repositoryMerging(RepositoryMerging repositoryMerging) {
            this.repositoryMerging = repositoryMerging;
            return this;
        }

        public ModelBuilderRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public ModelBuilderRequestBuilder lifecycleBindingsInjector(ModelTransformer lifecycleBindingsInjector) {
            this.lifecycleBindingsInjector = lifecycleBindingsInjector;
            return this;
        }

        public ModelBuilderRequest build() {
            return new DefaultModelBuilderRequest(this.session, this.requestType, this.locationTracking, this.recursive, this.source, this.profiles, this.activeProfileIds, this.inactiveProfileIds, this.systemProperties, this.userProperties, this.repositoryMerging, this.repositories, this.lifecycleBindingsInjector);
        }

        private static class DefaultModelBuilderRequest
        extends BaseRequest<Session>
        implements ModelBuilderRequest {
            private final RequestType requestType;
            private final boolean locationTracking;
            private final boolean recursive;
            private final ModelSource source;
            private final Collection<Profile> profiles;
            private final List<String> activeProfileIds;
            private final List<String> inactiveProfileIds;
            private final Map<String, String> systemProperties;
            private final Map<String, String> userProperties;
            private final RepositoryMerging repositoryMerging;
            private final List<RemoteRepository> repositories;
            private final ModelTransformer lifecycleBindingsInjector;

            DefaultModelBuilderRequest(@Nonnull Session session, @Nonnull RequestType requestType, boolean locationTracking, boolean recursive, @Nonnull ModelSource source, Collection<Profile> profiles, List<String> activeProfileIds, List<String> inactiveProfileIds, Map<String, String> systemProperties, Map<String, String> userProperties, RepositoryMerging repositoryMerging, List<RemoteRepository> repositories, ModelTransformer lifecycleBindingsInjector) {
                super(session);
                this.requestType = DefaultModelBuilderRequest.nonNull(requestType, "requestType cannot be null");
                this.locationTracking = locationTracking;
                this.recursive = recursive;
                this.source = source;
                this.profiles = profiles != null ? List.copyOf(profiles) : List.of();
                this.activeProfileIds = activeProfileIds != null ? List.copyOf(activeProfileIds) : List.of();
                this.inactiveProfileIds = inactiveProfileIds != null ? List.copyOf(inactiveProfileIds) : List.of();
                this.systemProperties = systemProperties != null ? Map.copyOf(systemProperties) : session.getSystemProperties();
                this.userProperties = userProperties != null ? Map.copyOf(userProperties) : session.getUserProperties();
                this.repositoryMerging = repositoryMerging;
                this.repositories = repositories != null ? List.copyOf(repositories) : null;
                this.lifecycleBindingsInjector = lifecycleBindingsInjector;
            }

            @Override
            public RequestType getRequestType() {
                return this.requestType;
            }

            @Override
            public boolean isLocationTracking() {
                return this.locationTracking;
            }

            @Override
            public boolean isRecursive() {
                return this.recursive;
            }

            @Override
            @Nonnull
            public ModelSource getSource() {
                return this.source;
            }

            @Override
            public Collection<Profile> getProfiles() {
                return this.profiles;
            }

            @Override
            public List<String> getActiveProfileIds() {
                return this.activeProfileIds;
            }

            @Override
            public List<String> getInactiveProfileIds() {
                return this.inactiveProfileIds;
            }

            @Override
            public Map<String, String> getSystemProperties() {
                return this.systemProperties;
            }

            @Override
            public Map<String, String> getUserProperties() {
                return this.userProperties;
            }

            @Override
            public RepositoryMerging getRepositoryMerging() {
                return this.repositoryMerging;
            }

            @Override
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            @Override
            public ModelTransformer getLifecycleBindingsInjector() {
                return this.lifecycleBindingsInjector;
            }
        }
    }

    public static enum RepositoryMerging {
        POM_DOMINANT,
        REQUEST_DOMINANT;

    }

    public static enum RequestType {
        BUILD_PROJECT,
        BUILD_EFFECTIVE,
        BUILD_CONSUMER,
        CONSUMER_PARENT,
        CONSUMER_DEPENDENCY;

    }
}

