/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.List;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface ArtifactResolverRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Collection<? extends ArtifactCoordinates> getCoordinates();

    @Nonnull
    public List<RemoteRepository> getRepositories();

    @Nonnull
    public static ArtifactResolverRequestBuilder builder() {
        return new ArtifactResolverRequestBuilder();
    }

    @Nonnull
    public static ArtifactResolverRequest build(@Nonnull Session session, @Nonnull Collection<? extends ArtifactCoordinates> coordinates) {
        return ArtifactResolverRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).coordinates(BaseRequest.nonNull(coordinates, "coordinates cannot be null")).build();
    }

    @Nonnull
    public static ArtifactResolverRequest build(@Nonnull Session session, @Nonnull Collection<? extends ArtifactCoordinates> coordinates, List<RemoteRepository> repositories) {
        return ArtifactResolverRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).coordinates(BaseRequest.nonNull(coordinates, "coordinates cannot be null")).repositories(repositories).build();
    }

    @NotThreadSafe
    public static class ArtifactResolverRequestBuilder {
        Session session;
        Collection<? extends ArtifactCoordinates> coordinates;
        List<RemoteRepository> repositories;

        ArtifactResolverRequestBuilder() {
        }

        @Nonnull
        public ArtifactResolverRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequestBuilder coordinates(Collection<? extends ArtifactCoordinates> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public ArtifactResolverRequest build() {
            return new DefaultArtifactResolverRequest(this.session, this.coordinates, this.repositories);
        }

        private static class DefaultArtifactResolverRequest
        extends BaseRequest<Session>
        implements ArtifactResolverRequest {
            @Nonnull
            private final Collection<? extends ArtifactCoordinates> coordinates;
            @Nullable
            private final List<RemoteRepository> repositories;

            DefaultArtifactResolverRequest(@Nonnull Session session, @Nonnull Collection<? extends ArtifactCoordinates> coordinates, @Nonnull List<RemoteRepository> repositories) {
                super(session);
                this.coordinates = DefaultArtifactResolverRequest.unmodifiable(DefaultArtifactResolverRequest.nonNull(coordinates, "coordinates cannot be null"));
                this.repositories = repositories;
            }

            @Override
            @Nonnull
            public Collection<? extends ArtifactCoordinates> getCoordinates() {
                return this.coordinates;
            }

            @Override
            @Nullable
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }
        }
    }
}

